#ifndef _SMALL_GRID_SERVER_H
#define _SMALL_GRID_SERVER_H

/** @brief a simple library for grid computing 
  * SMALL PARADIGM SERVER
  */

#ifdef __cplusplus
extern "C" {
#endif

/** init grid_computing (CLIENT, SERVER) */
int grid_init(int argc, char *argv[], const char *project_name);

/** done grid_computing (CLIENT,SERVER) */
int grid_done(int ret_value);
  
/** return the project name */
const char *get_project_name();

/** read data from Pool
  * @param WU the WU ID (in Client this parameter is unused, since it is sent only to server)
  * @param ID memory chunk identifier
  * @param data a data structure
  * @return TRUE if chunk exists
  **/
int pop_data(int WU, int ID, char *ptr, int size);

/** write data to the Pool
  * @param WU the WU ID (-1 to all WorkUnit as common data)
  * @param ID memory chunk identifier
  * @param data a data structure
  */
int push_data(int WU, int ID, const char *ptr, int size);

/** Create @a nWorkUnits different Work Units (SERVER) **/
int create_work_units(int nWorkUnits);

/** activate a WU (SERVER) */ 
int run_work_unit(int WU);

/** execute all WU (SERVER) */
int run_all_work_units(int WU);

/** Wait for a single work unit terminates (SERVER) */
int wait_for_work_unit_finishes(int WU);

/** Wait for all work units terminate (SERVER) */
int wait_all_works_unit_finish();

#ifdef __cplusplus
}
#endif

#endif
