#include "server_grid.h"
#include "data.h"
#include "common.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>                  // has inet_aton()
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

static char project_name[256];
static int s=-1;
static int wu=0;
static int quit=0;
static pthread_cond_t cond;
static pthread_mutex_t mutex;
static int verbosity = 1;

struct work_unit {
  int active;
  int status;
  int ret_value;
};

static struct work_unit *wus = NULL;

int create_work_units(int nWorkUnits)
{
  wu = nWorkUnits;
  wus = (struct work_unit *) malloc(sizeof(struct work_unit) * nWorkUnits);
  memset(wus, 0, sizeof(struct work_unit) * nWorkUnits);
  return 0;
}

int run_work_unit(int WU)
{
  wus[WU].active=1;
  return 0;
}


int run_all_work_units(int WU)
{
  int i;
  for(i=0;i<wu;i++)
    wus[i].active=1;
  return 0;
}

static int wu_remaining()
{
  int i;
  int count = wu;
  for(i=0;i<wu;i++)
    if((wus[i].active==0)&&(wus[i].status==2))
      count--;
  return count;
}

int wait_for_work_unit_finishes(int WU)
{
  while(wus[WU].status!=1)
    {
    pthread_mutex_lock( &mutex );
    pthread_cond_wait( &cond, &mutex);
    pthread_mutex_unlock( &mutex );
    }
  return wus[WU].status;
}

int wait_all_works_unit_finish()
{
  int r;
  while((r=wu_remaining())>0)
  {
  printf("--- %u working units to go\n", r);
  pthread_mutex_lock( &mutex );
  pthread_cond_wait( &cond, &mutex);
  pthread_mutex_unlock( &mutex );
  }
  return 0;
}

static int find_available_wu()
{
  int i;
  for(i=0;i<wu;i++)
    if((wus[i].active==1)&&(wus[i].status==0))
	return i;
  return -1;
}

// una lista explicita
struct data_list {
  int wu;
  int id;
  struct data data;

  struct data_list *next;
};

// the data root
static struct data_list *root = NULL;

static struct data_list *find(int wu, int id)
{
  struct data_list *cur = root;
  for(;(cur);cur = cur->next)
    {
      if((id==cur->id) && ((cur->wu == -1)||(wu==cur->wu)) )
	  return cur;
    }
  return NULL;
}

static struct data_list *reserve_data(int WU, int ID, int size)
{
  struct data_list *cur = find(WU, ID);
  if(cur)
    {
      realloc_data(&cur->data, size);
      return cur;
    }
    else
    {
      struct data_list *new = (struct data_list *) malloc(sizeof(struct data_list));
      alloc_data(&new->data, size);
      new->next = root;
      new->id = ID;
      new->wu = WU;
      root = new;
      return root;
    }
}

static void * InitiateThreadTCP( void *p )
    {
      int sck = (int)p;
      int r;
      int cur_wu = -1;
      struct header h;

      while(recv(sck, &h, sizeof(struct header), 0)>0)
	{
	switch(h.magic)
	{
	  case LOGIN_PACKET_MAGIC:
	  {
	    struct login_packet login;
	    struct header h;
	    struct login_reply reply; 
	    aff_read(sck, (char *) &login, sizeof(login));
	    h.magic = LOGIN_REPLY_MAGIC;
	    h.size = sizeof(struct login_reply);
	    
	    reply.grant=0;
	    reply.wu = cur_wu = find_available_wu();
// 	    aff_write(sck, (const char*) &h, sizeof(struct header));
	    aff_write(sck, (const char*) &reply, sizeof(struct login_reply));
	    if(cur_wu != -1)
	      {
	      wus[cur_wu].status = 1;
	      printf("--- working unit %u active\n", cur_wu);
	      }
	      else
	      {
		puts("--- no more working units avaiable");
	      }
	    
	  }
	    break;
	  case CLOSE_PACKET_MAGIC:
	  {
	    struct close_packet closing;
	    aff_read(sck, (char *) &closing, sizeof(closing));
	    wus[cur_wu].status = 2;
	    wus[cur_wu].active = 0;
	    wus[cur_wu].ret_value = closing.ret_value;
	    printf("--- working unit %u terminated with %d\n", cur_wu, closing.ret_value);
	    pthread_cond_signal( &cond );
	    cur_wu = -1;
	  }
	    break;
	  case DATA_REQUEST_MAGIC:
	  {
	    struct data_request req;
	    struct data_list *source;
	    aff_read(sck, (char *) &req, sizeof(req));
	    source = find(req.wu, req.id);
	    if(source)
	      {
		struct header h;
		struct data_packet p;
		printf("--- request %d/%d: %u bytes\n", req.wu, req.id, source->data.size);

		h.magic = DATA_PACKET_MAGIC;
		h.size = sizeof(struct data_packet) + source->data.size;
		aff_write(sck, (char *) &h, sizeof(h));
		p.wu = source->wu;
		p.id = source->id;
		aff_write(sck, (char *) &p, sizeof(p));
		aff_write(sck, (char *) source->data.ptr, source->data.size);
	      }
	      else
	      {
		printf("--- data request unknown: %d/%d!\n", req.wu, req.id);
		close(sck);
		return(void*)(-1);
	      }
	  }
	    break;
	    
	  case DATA_PACKET_MAGIC:
	  {
	    struct data_packet data;
	    struct data_list *target;
	    aff_read(sck, (char *) &data, sizeof(data));
	    target = reserve_data(data.wu, data.id, h.size - sizeof(data) );
	    aff_read(sck, (char *) target->data.ptr, target->data.size);
	  }
	    break;
	  default:
	    puts("--- header magic wrong!");
	    close(sck);
	    return (void*)-1;
	    break;
	}
	
	}

      if(cur_wu != -1)
      {
	wus[cur_wu].status = 0;
	wus[cur_wu].active = 0;
      }

      // gestire le comunicazioni
      close(sck);
      return NULL;
    }
    
static void *accept_thread(void *pp)
{
    struct sockaddr_in cli_addr;
    
    while( !quit ) {
            socklen_t clilen = sizeof(cli_addr);
	    int newsockfd;
            newsockfd = accept(s, (struct sockaddr *) &cli_addr, &clilen);
            if ( newsockfd < 0 ) {
                perror("Nuova connessione non creata");
            } else {
                pthread_t pTh;
                pthread_create(&pTh, NULL, InitiateThreadTCP, (void *)newsockfd);
            }
        }

  return 0;
}


int grid_init(int argc, char *argv[], const char *_project_name)
{
   struct sockaddr_in name;
   struct login_packet packet;
   struct login_reply reply;
   struct sockaddr_in serv_addr;
   pthread_t pTh;

   pthread_mutex_init( &mutex, NULL );
   pthread_cond_init( &cond, NULL );

   strcpy(project_name, _project_name);
   
   // read params
   
   s = socket(PF_INET, SOCK_STREAM, 0);
    if (s < 0) {
      perror("could not create socket");
      return -1;
    }
    
  bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(GRID_PORT);
    if ( bind(s, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0 ) {
        perror("FATAL: Impossibile effettuare il bind del listener TCP");
        exit(1);
    }
  
  listen(s, 8);
  pthread_create(&pTh, NULL, accept_thread, (void *)s);
  
  return 0;
}


int grid_done(int ret_value)
{
  struct data_list *cur;
  // DISCONNECT ALL
  quit = 1;
  // release all memory
  for(cur = root; (cur); cur=cur->next)
      free_data(&cur->data);
  root = NULL;
  pthread_cond_destroy(&cond);
  pthread_mutex_destroy(&mutex);

  return 0;
}

const char *get_project_name()
{
  return project_name;
}

//int pop_data(int WU, int ID, struct data *d)
int pop_data(int WU, int ID, char *ptr, int size)
{
  struct data_list *cur = find(WU, ID);
  if(cur == NULL)
    return 0;
  export_data(ptr, size, &cur->data);
  return 1;
}

// int push_data(int WU, int ID, const struct data *data)
int push_data(int WU, int ID, const char *ptr, int size)
{
  struct data_list *cur = find(WU, ID);
  if(cur)
    {
      printf("-- replace data %d/%d\n", WU, ID);
      // REPLACE
      import_data(&cur->data, ptr, size);
    }
    else
    {
      struct data_list *new = (struct data_list *) malloc(sizeof(struct data_list));
      init_data(&new->data); 
      import_data(&new->data, ptr, size);
      new->id = ID;
      new->wu = WU;
      new->next = root;
      root = new;
      printf("-- allocated data %d/%d: %u bytes\n", WU, ID, size);
    }
  return 1;
}


