#ifndef _DATA_H
#define _DATA_H

/** A data chunk */
struct data {
  unsigned char *ptr;
  unsigned int size;
};

/** alloc memory */
void alloc_data(struct data *data, int size);

/** reset data object without alloc memory */
void init_data(struct data *dst);

/** re-alloc memory */
void realloc_data(struct data *data, int size);

/** Release memory */
void free_data(struct data *data);

/** copy src data to dst */
void copy_data(struct data *dst, const struct data *src);

/** copy src data to dst */
int import_data(struct data *dst, const char *src, int size);

/** copy src data to dst */
int export_data(char *dst, int size, const struct data *src);

/** Save data(s) as an atomic check point 
  *  Data will be saved on disk and used on wakeup
  */
void write_checkpoint(const struct data **data, int n_buffers);

/** Read data(s) as an atomic check point */
int read_checkpoint(struct data **data, int n_buffers);


#endif
