#ifndef _COMMON_H
#define _COMMON_H

#ifdef __cplusplus
extern "C" {
#endif

#define GRID_PORT		9876

/// a common header for stream 
struct header {
   unsigned int magic;
   unsigned int size;	// dimensione del corpo dati
};

// CLIENT ->SERVER
#define LOGIN_PACKET_MAGIC	0x12345678

struct login_packet {
   unsigned int version;
   char project_name[256];
};

// SERVER->CLIENT
#define LOGIN_REPLY_MAGIC	0x10000001

struct login_reply {
    int grant;
    int wu;
};

// CLIENT->SERVER
#define CLOSE_PACKET_MAGIC	0x14000001

struct close_packet {
  int wu;
  int ret_value;
};

// CLIENT->SERVER
#define DATA_REQUEST_MAGIC	0x11000001

struct data_request {
    int wu;
    int id;
};

// SERVER->CLIENT
// CLIENT->SERVER
#define DATA_PACKET_MAGIC	0x12000001

struct data_packet {
  int wu;
  int id;
};

int aff_read(int desc, char *buffer, int len);
int aff_write(int s, const char *mem, int len);

#ifdef __cplusplus
}
#endif
#endif
