#include "data.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void init_data(struct data *dst)
{
  dst->ptr=NULL;
  dst->size=0;
}

void alloc_data(struct data *data, int size)
{
  data->size = size;
  data->ptr = (unsigned char *) malloc(size);
  memset(data->ptr,0,data->size);
}

void realloc_data(struct data *data, int size)
{
  if(data->size == size)
      return;
  
  if(data->ptr!=NULL)
      free(data->ptr);
  
  alloc_data(data, size);
}

void free_data(struct data *data)
{
  free(data->ptr);
  init_data(data);
}

void copy_data(struct data *dst, const struct data *src)
{
  alloc_data(dst, src->size);
  memcpy(dst->ptr, src->ptr, src->size);
}

int import_data(struct data *dst, const char *src, int size)
{
  realloc_data(dst, size);
  memcpy(dst->ptr, src, size);
  return 0;
}

int export_data(char *dst, int size, const struct data *src)
{
  if(src->size != size)
  {
    return -1;
  }
  memcpy(dst, src->ptr, size);
  return 0;
}

/**********************************************
* int aff_read(int desc, char *buffer, int len)
* 
* read affidabile. Legge un numero esatto di 
* byte da uno stream.
**********************************************/
int aff_read(int desc, char *buffer, int len)
{
int ret;
int size = 0;

if(buffer)
{

while(len>0)
	{
	ret = recv(desc, buffer + size, len, 0);	/* len0 bug */
	if(ret==0)
		return 0;	
	if(ret==-1) 
		return -1;
	size+=ret;
	len-=ret;
	}
}
return size;
}

/**********************************************
* int aff_write(SOCKET s, const char *mem, int len)
* 
* write affidabile.
**********************************************/

int aff_write(int s, const char *mem, int len)
{
	int ret;

	if(s!=-1)
	{

	if (mem)
	while(len>0) {
		ret = send(s, mem, len,0);
		if((ret==0)||(ret<0))
			return -1;
		mem+=ret;
		len-=ret;
		}
	}
	return 0;
}


void write_checkpoint(const struct data **data, int n_buffers)
{
  FILE *fp;
  int i;
  // TODO: use multiple checkpoints
  fp=fopen("checkpoint.tmp", "wb");
  fwrite(&n_buffers, sizeof(int), 1, fp);
  for(i=0;i<n_buffers;++i)
    {
    fwrite(&data[i]->size,sizeof(int), 1,  fp );
    fwrite(data[i]->ptr, data[i]->size, 1, fp);
    }
  fclose(fp);
  puts("checkpoint written");
}

int read_checkpoint(struct data **data, int n_buffers)
{
  FILE *fp;
  int i;
  int tmp;
  // TODO: use multiple checkpoints
  fp=fopen("checkpoint.tmp", "rb");
  if(fp==NULL)
      return 0;
  fread( &tmp, sizeof(int), 1, fp);
  if(tmp!=n_buffers)
    {
      puts("invalid checkpoint file");
      fclose(fp);
      return 0;
    }

  for(i=0;i<n_buffers;++i)
    {
    fread(&tmp, sizeof(int), 1, fp);
    alloc_data(data[i], tmp);
    fread(data[i]->ptr, data[i]->size, 1, fp);
    }
  fclose(fp);
  return 1;
}

