#ifndef _SMALL_GRID_CLIENT_H
#define _SMALL_GRID_CLIENT_H

/** @brief a simple library for grid computing 
  * SMALL PARADIGM CLIENT 
  */

#ifdef __cplusplus
extern "C" {
#endif

/** init grid_computing (CLIENT, SERVER) */
int grid_init(int argc, char *argv[], const char *project_name);

/** done grid_computing (CLIENT,SERVER) */
int grid_done(int ret_value);
  
/** Start a new Working Unit (CLIENT) */
int complete_and_start_new_wu(int ret_value);

/** return the WU identifier */
int get_wu();

/** return the project name */
const char *get_project_name();

/** read data from Pool
  * @param ID memory chunk identifier
  * @param data a data structure
  * @return TRUE if chunk exists
  **/
int pop_data(int ID, char *ptr, int size);

/** write data to the Pool
  * @param ID memory chunk identifier
  * @param data a data structure
  */
int push_data(int ID, const char *ptr, int size);

#ifdef __cplusplus
}
#endif

#endif
