#include "client_grid.h"
#include "data.h"
#include "common.h"

#include <sys/time.h>
#include <sys/resource.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>                  // has inet_aton()
#include <netdb.h>
#include <unistd.h>
#include <string.h>

static char project_name[256];
static int s;
static int wu;
static int verbosity = 1;

int send_header(int magic, int size)
{
  struct header h;
  h.magic=magic;
  h.size=size;
  aff_write(s, (const char *)&h, sizeof(struct header));
}

int send_packet(int magic, int size, const char *packet)
{
  struct header h;
  h.magic=magic;
  h.size=size;
  aff_write(s, (const char *)&h, sizeof(struct header));
  aff_write(s, (const char *)packet, size);
}

int grid_init(int argc, char *argv[], const char *project_name)
{
   struct sockaddr_in name;
   struct login_packet packet;
   struct login_reply reply;
   
   // CHANGE PRIORITY
   if(argc<2)
   {
     puts("app <serverhost> [options]");
     return -1;
   }
   
   setpriority(PRIO_PROCESS, 0, 19);
   
  // CONNECT TO SERVER, LOAD DATA
   s = socket(PF_INET, SOCK_STREAM, 0);
    if (s < 0) {
      perror("could not create socket");
      return -1;
    }
  
    // Determine the socket address.
    
    name.sin_family = AF_INET;
    name.sin_port = htons(GRID_PORT);
    if (!inet_aton(argv[1], &(name.sin_addr))) {
      struct hostent* hostinfo = gethostbyname(argv[1]);
      if ( hostinfo == NULL ) {
	 perror("gethostbyname failed");
        }
      else
        name.sin_addr = *(struct in_addr *) hostinfo->h_addr;
    }

    // Connect the local socket to the remote machine
    if(connect(s, (struct sockaddr*)&name, sizeof(name)) < 0 ) {
      close(s); 
      // simulation finished!
      puts("impossibile contattare il server (wu terminated?)");
      return -1;
      }	

  packet.version = 1;
  strcpy(packet.project_name, project_name);
  send_packet(LOGIN_PACKET_MAGIC, sizeof(struct login_packet),(const char *) &packet);
  
  aff_read(s, (char *) &reply, sizeof(struct login_reply));
  wu = reply.wu;
  if(wu == -1)
    {
      close(s);
      puts("no more working unit available");
      return -1;
    }
    
  printf("--- working unit %u\n", wu);

  return 0;
}


int grid_done(int ret_value)
{
  struct close_packet p;
  p.wu = wu;
  p.ret_value = ret_value;
  send_packet(CLOSE_PACKET_MAGIC, sizeof(struct close_packet),(const char *) &p);
  close(s);
  printf("--- working unit %u terminated with %d\n", wu, ret_value);
  wu = -1;
  return 0;
}

const char *get_project_name()
{
  return project_name;
}

int get_wu()
{
  return wu;
}


// int pop_data(int __unused_WU, int ID, struct data *d)
int pop_data(int ID, char *ptr, int size)
{
  struct data_request req;
  struct data_packet reply;
  struct header header;
  req.wu = wu;
  req.id = ID;
  send_packet(DATA_REQUEST_MAGIC, sizeof(struct data_request), (const char *) &req);

  aff_read(s, (char *) &header, sizeof(struct header));
  aff_read(s, (char *) &reply, sizeof(struct data_packet));
  if((header.size - sizeof(struct data_packet)) != size)
  {
    printf("-- invalid data size\n");
    return -1;
  }
//   alloc_data(d, header.size - sizeof(struct data_packet) );
  printf("--- data %d/%d: %u bytes\n", req.wu, req.id, size);
  aff_read(s, (char *) ptr, size);
  return 0;
}

int push_data(int ID, const char *ptr, int size)
// int push_data(int WU, int ID, const struct data *data)
{
  struct data_packet d;
  d.wu = wu;
  d.id = ID;
  send_header(DATA_PACKET_MAGIC, sizeof(struct data_packet) + size);
  aff_write(s, (const char *) &d, sizeof(struct data_packet));
  aff_write(s, (const char *) ptr, size);
  return 0;
}
