#include <iostream>
#include "kalman.h"
#include <stdlib.h>
#include <fstream>

double frand()
{
  return (double) rand() / (double) RAND_MAX;
}

#if 0
/** 
 * x(0) = x(0) + x(1) * dt
 * x(1) = x(1)
 * x(2) = x(2)
 * x(3) = x(3)
 * */

class process_model {
  
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> Q;
  
  double dt;
public:
  process_model() : tmp(4), Q(4,4) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0) + x(1) * dt;
    tmp(1) = x(1);
    tmp(2) = x(2);
    tmp(3) = x(3);
    return tmp;
  }
};

class observation_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> R;
  
public:
  observation_model() : tmp(2), R(2,2) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0);
    tmp(1) = x(2) * x(1) + x(3);
    return tmp;
  }
};


int main()
{
  // UKF
  unscented_kalman_filter<double> ukf(4);
  process_model predict;
  observation_model observe;
  std::ifstream in("kalman7.dat");
  
  boost::numeric::ublas::vector<double> initial_state(4);
  boost::numeric::ublas::scalar_matrix<double> initial_P(4,4, 1.0);
  
  initial_state(0) = 0.0;
  initial_state(1) = 0.0;
  initial_state(2) = 1.0;
  initial_state(3) = 0.0;
  
  ukf.set(initial_state, initial_P);
    
  predict.Q = boost::numeric::ublas::zero_matrix<double>(4,4);
  predict.Q(0,0) = 0.0001*0.0001; 
  predict.Q(1,1) = 0.5*0.5;
  predict.Q(2,2) = 0.0001*0.0001;
  predict.Q(3,3) = 0.0000001*0.0000001;

  observe.R = boost::numeric::ublas::zero_matrix<double>(2,2);
  observe.R(0,0) = 0.5*0.5; 
  observe.R(1,1) = 1.5*1.5; 
  
  double t0 = 0.0;
  int frame = 0;
  
   while(in)
    { 
      double t, s, a;
      
      in >> t >> s >> a;
      
      if(frame == 0)
      {
	predict.dt = 0.0;
	initial_state(0) = s;
	initial_state(1) = a;
	ukf.set(initial_state, initial_P);
	frame = 1;
      }
      else
        predict.dt = t - t0;
      
      t0 = t;
      
      ukf.predict(predict);
      
      boost::numeric::ublas::vector<double> z(2);
      z(0) = s;
      z(1) = a;

      if(s < 0.5)
      {
	observe.R(1,1) = 0.1*0.1; 
      }
      else
      {
	observe.R(1,1) = 1.5*1.5; 
      }

      
      ukf.observe(observe, z, linear_compare<double>() );
      
      std::cout << s << ' ' << a << ' ' << ukf.state()(0) << ' ' << ukf.state()(1) << ' ' << ukf.state()(2) << ' ' << ukf.state()(3) << std::endl;

    }
  
return 0;
}
#endif

int main()
{
  // KF
  kalman_filter<double> filter(3);
  linearized_predict<> predict(3);
  linearized_observe<> observe(2, 3);
  
  boost::numeric::ublas::vector<double> initial_state(3);
  boost::numeric::ublas::matrix<double> initial_P(3,3);
  
  initial_P = boost::numeric::ublas::zero_matrix<double>(3,3);
  initial_P(0,0) = 0.1;
  initial_P(1,1) = 1.0;
  initial_P(2,2) = 0.5;
  
  initial_state(0) = 0.0;
  initial_state(1) = 0.0;
  initial_state(2) = 0.0;
  
  filter.set(initial_state, initial_P);
  
  predict.A = boost::numeric::ublas::zero_matrix<double>(3,3);
  predict.A(0,0) = 1.0;
  predict.A(0,1) = 0.0; // t
  predict.A(1,1) = 1.0;
  predict.A(2,2) = 1.0;
  
//   std::cout << predict.A << std::endl;	
  
  predict.Q = boost::numeric::ublas::zero_matrix<double>(3,3);
  predict.Q(0,0) = 0.000000001;  // rumore di processo sulla velocita'
  predict.Q(1,1) = 0.001;        // rumore di processo sull'accelerazione
  predict.Q(2,2) = 0.000000001;  // rumore di processo sul bias1
    
  observe.H = boost::numeric::ublas::zero_matrix<double>(2,3);
  observe.H(0,0) = 1.0; 
  observe.H(1,1) = 1.0; // yawrate
  observe.H(1,2) = 1.0; // bias
  
  observe.R = boost::numeric::ublas::zero_matrix<double>(2,2);
  
  observe.R(0,0) =  0.1*0.1;
  observe.R(1,1) =  1.0; 
    
  std::ifstream in("kalman7.dat");
  
  double t0 = 0.0;
  int frame = 0;
  double s0 = 0.0;
  
   while(in)
    { 
      double t, s, a;
      double dt;
      
      in >> t >> s >> a;
      
      if(frame == 0)
      {
	predict.A(0,1) = 0.0;
	initial_state(0) = s;
	initial_state(1) = a;
	filter.set(initial_state, initial_P);
	frame = 1;
	dt = 10000.0;
      }
      else
      {
        predict.A(0,1) = dt = t - t0;
      }
      
      t0 = t;
      
      filter.predict(predict);
      
      boost::numeric::ublas::vector<double> z(2);
      z(0) = s;
      z(1) = a;

      if(s < 0.5)
      {
	observe.R(1,1) = 0.1*0.1; 
      }
      else
      {
	observe.R(1,1) = 1.5*1.5; 
      }

      
      filter.observe(observe, z, linear_compare<double>() );
      
      std::cout << s << ' ' << a << ' ' << (s - s0)/dt << ' ' << filter.state()(0) << ' ' << filter.state()(1) << ' ' << filter.state()(2) << std::endl;
      
      s0 = s;

    }
  
return 0;
}
