#include <iostream>
#include "kalman.h"
#include <stdlib.h>

double frand()
{
  return (double) rand() / (double) RAND_MAX;
}
# if 0
class process_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> Q;
  
public:
  process_model() : tmp(4), Q(4,4) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0) + x(1);
    tmp(1) = x(1);
    tmp(2) = x(2) + x(3);
    tmp(3) = x(3);
    return tmp;
  }
};

class observation_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> R;
  
public:
  observation_model() : tmp(2), R(2,2) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0) / x(2);
    tmp(1) = ( (x(0) + x(1) ) / (x(2) + x(3) ) ) - x(0)/x(2);
    return tmp;
  }
};

int main()
{
  unscented_kalman_filter<double, boost::numeric::ublas::matrix<double> > filter(4);
  process_model predict;
  observation_model observe;
  
  boost::numeric::ublas::vector<double> initial_state(4);
  boost::numeric::ublas::scalar_matrix<double> initial_P(4,4, 1.0);
  
  initial_state(0) = 11.0;
  initial_state(1) = 0.0;
  initial_state(2) = 11.0;
  initial_state(3) = 0.0;
  
  filter.set(initial_state, initial_P);
  
  
  predict.Q = boost::numeric::ublas::zero_matrix<double>(4,4);
  predict.Q(0,0) = 0.01; // low process noise
  predict.Q(1,1) = 0.01; // low process noise
  predict.Q(2,2) = 0.01; // low process noise
  predict.Q(3,3) = 0.01; // low process noise

  observe.R = boost::numeric::ublas::zero_matrix<double>(2,2);
  observe.R(0,0) = 1.0; 
  observe.R(1,1) = 0.1*0.1; 

  double tx = 10.0;
  double tz = 10.0;
  double vx = 2.0;
  double vz = 0.1;

  int count = 100;
   while(--count)
    {
      boost::numeric::ublas::vector<double> z(2);
      filter.predict(predict);
      
      z(0) = tx/tz + (1.0 * frand() - 0.5); // observation noise
      z(1) = (tx + vx)/(tz + vz) - (tx/tz) + (0.1 * frand() - 0.05); // observation noise
      
      filter.observe(observe, z, linear_compare<double>() );
      
      std::cout << tx << ' ' << filter.state()(0) << ' ' << tz << ' ' << filter.state()(2) << std::endl;

      tx+=vx;
      tz+=vz;
      
    }
  
return 0;
}
#endif

#if 0
const double height = 2.0; // altezza camera

class process_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> Q;
  
public:
  process_model() : tmp(2), Q(2,2) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0);
    tmp(1) = x(1);
    return tmp;
  }
};

class observation_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> R;
  
public:
  observation_model() : tmp(2), R(2,2) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0) / x(1);
    tmp(1) = height / x(1);
    return tmp;
  }
};

int main()
{
  unscented_kalman_filter<double, boost::numeric::ublas::matrix<double> > filter(2);
  process_model predict;
  observation_model observe;
  
  boost::numeric::ublas::vector<double> initial_state(2);
  boost::numeric::ublas::scalar_matrix<double> initial_P(2,2, 10.0);
  
  initial_state(0) = 10.0;
  initial_state(1) = 5.0;
  
  filter.set(initial_state, initial_P);
    
  predict.Q = boost::numeric::ublas::zero_matrix<double>(2,2);
  predict.Q(0,0) = 0.01; // low process noise
  predict.Q(1,1) = 0.01; // low process noise

  observe.R = boost::numeric::ublas::zero_matrix<double>(2,2);
  observe.R(0,0) = 1.0; 
  observe.R(1,1) = 1.0; 

  double tx = 10.0;
  double tz = 5.0;

  int count = 100;
   while(--count)
    {
      boost::numeric::ublas::vector<double> z(2);
      filter.predict(predict);
      
      z(0) = tx/tz + (1.0 * frand() - 0.5); // observation noise
      z(1) = height/tz + (1.0 * frand() - 0.5); // observation noise
      
      filter.observe(observe, z, linear_compare<double>() );
      
      std::cout << tx << ' ' << filter.state()(0) << ' ' << tz << ' ' << filter.state()(1) << std::endl;
      
//       tx += 0.1;
//       tz += 0.05;
    }
  
return 0;
}
#endif

const double height = 2.0; // altezza camera
const double k = 1000.0; // focal lenght in px

class process_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> Q;
  
public:
  process_model() : tmp(1), Q(1,1) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0);
    return tmp;
  }
};

class observation_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> R;
  
public:
  observation_model() : tmp(1), R(1,1) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = k *  height / x(0);
    return tmp;
  }
};

class ekf_predict_type: public linearized_predict<> {
  boost::numeric::ublas::vector<double> out;
public:
 ekf_predict_type() : linearized_predict<>(1), out(1) { }
 
 const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
 {
   out(0) = x(0);
   return out;
 }
 
 void update(const boost::numeric::ublas::vector<double> & x)
 {
   A(0,0) = 1.0;
 }
  
};

class ekf_observe_type: public linearized_observe<> {
  boost::numeric::ublas::vector<double> out;
public:
 ekf_observe_type() : linearized_observe<>(1, 1), out(1) { }
 
 const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
 {
   out(0) =  k *  height / x(0);
   return out;
 }
 void update(const boost::numeric::ublas::vector<double> & x)
 {
   H(0,0) = - k *  height / (x(0) * x(0));
 }
  
};

int main()
{
  // UKF
  unscented_kalman_filter<double> ukf(1);
  process_model predict;
  observation_model observe;
  
  // EKF
  extended_kalman_filter<double> ekf(1);
  ekf_predict_type ekf_predict;
  ekf_observe_type ekf_observe;
  
  boost::numeric::ublas::vector<double> initial_state(1);
  boost::numeric::ublas::scalar_matrix<double> initial_P(1,1, 10.0);
  
  initial_state(0) = 10.0;
  
  ukf.set(initial_state, initial_P);
  ekf.set(initial_state, initial_P);
    
  predict.Q = boost::numeric::ublas::zero_matrix<double>(1,1);
  predict.Q(0,0) = 0.03*0.03; // low process noise
  ekf_predict.Q = predict.Q;
  

  observe.R = boost::numeric::ublas::zero_matrix<double>(1,1);
  observe.R(0,0) = 2.0*2.0; 
  ekf_observe.R = observe.R;
  
  double tz = 10.0;

  int count = 0;
   while(++count < 1000)
    {
      
      boost::numeric::ublas::vector<double> z(1);
      ukf.predict(predict);
      
      ekf.predict(ekf_predict);
      
      z(0) = (k*(height/tz)) + (1.0 * frand() - 0.5); // observation noise
      
      ukf.observe(observe, z, linear_compare<double>() );
      ekf.observe(ekf_observe, z, linear_compare<double>() );
      
      std::cout << tz << ' ' << ukf.state()(0) << ' ' << ekf.state()(0) << ' ' << (k*height)/z(0) <<  std::endl;

      tz = 10.0 + 1.0 * cos(count / 100.0);
      
    }
  
return 0;
}
