#include <iostream>
#include "kalman.h"
#include <stdlib.h>

double frand()
{
  return (double) rand() / (double) RAND_MAX;
}

class process_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> Q;
  
public:
  process_model() : tmp(1), Q(1,1) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & f(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0);
    return tmp;
  }
};

class observation_model {
  boost::numeric::ublas::vector<double> tmp;
public:
  // rumore di processo
  boost::numeric::ublas::matrix<double> R;
  
public:
  observation_model() : tmp(1), R(1,1) { }
  
  void update(boost::numeric::ublas::vector<double> & x)
  {
    // do nothing
  }
  
  const boost::numeric::ublas::vector<double> & h(const boost::numeric::ublas::vector<double> & x)
  {
    tmp(0) = x(0)*x(0);
    return tmp;
  }
};

/** esempio di un sistema monodimensionale del tipo:
 * 
 *  x' = a * x * x + w
 *  z = b * x + v
 * */
int main()
{
  unscented_kalman_filter<double, boost::numeric::ublas::matrix<double> > filter(1);
  process_model predict;
  observation_model observe;
  
  boost::numeric::ublas::vector<double> initial_state(1);
  boost::numeric::ublas::matrix<double> initial_P(1,1);
  
  initial_state(0) = 0.0;
  initial_P(0,0) = 1.0;
  
  filter.set(initial_state, initial_P);
  
  double truevalue = 1.0;
  
  predict.Q(0,0) = 0.01; // low process noise
  
  observe.R(0,0) = 1.0; // high observation noise
  
//   double x = 1.0;
//   double p = 0.0;
  int count = 100;
   while(--count)
    {
      boost::numeric::ublas::vector<double> z(1);
      filter.predict(predict);
      
      truevalue = truevalue + 0.1 * frand() - 0.05;  // < 0.1
      
//       x = x;
//       double k = p * 
      
      z(0) = truevalue*truevalue + (0.5 * frand() - 0.25);
      
      filter.observe(observe, z, linear_compare<double>() );
      
      std::cout << truevalue << ' ' << z(0) << ' ' << filter.state()(0) << std::endl;
      
    }
  
return 0;
}