#include <iostream>
#include "kalman.h"
#include <stdlib.h>

double frand()
{
  return (double) rand() / (double) RAND_MAX;
}

/** esempio di un sistema bidimensionale del tipo:
 * 
 *  S = S + V 
 *  V = V
 *  z = S + v
 * */
int main()
{
  kalman_filter<double, boost::numeric::ublas::matrix<double> > filter(2);
  linearized_predict<boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double> > predict(2);
  linearized_observe<boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double> > observe(2, 1);
  
  boost::numeric::ublas::vector<double> initial_state(2);
  boost::numeric::ublas::matrix<double> initial_P(2,2);
  
  initial_state(0) = 1.0;
  initial_state(1) = 0.01;
  
  initial_P(0,0) = 0.0;
  initial_P(1,0) = 0.0;
  initial_P(0,1) = 0.0;
  initial_P(1,1) = 0.0;
  
  filter.set(initial_state, initial_P);
  
  double truevalue = 1.0;
  double truespeed = 0.01;
  
  predict.A(0,0) = 1.0;
  predict.A(0,1) = 1.0; // 1 secondo
  predict.A(1,0) = 0.0; 
  predict.A(1,1) = 1.0; 
  
  predict.Q(0,0) = 0.001; 
  predict.Q(1,1) = 0.00001; 
  predict.Q(1,0) = 0.00; 
  predict.Q(0,1) = 0.00; 
  
  //
  observe.H(0,0) = 1.0; // vedo S al 100%
  observe.H(0,1) = 0.0; // non vedo V
  
  // rumore di osservazione
  observe.R(0,0) = 0.5; // high observation noise
  
//   std::cout << "system: " << predict.A << std::endl;
  
  double x = 0.0;
  double p = 0.0;
  int count = 1000;
  while(--count)
    {
      boost::numeric::ublas::vector<double> z(1);
      filter.predict(predict);
      
      truevalue += truespeed; /* + (0.01 * frand() - 0.005);  // < 0.1 */
      
      z(0) = truevalue; /* + (0.5 * frand() - 0.25); */
      
      filter.observe(observe, z, linear_compare<double>());
      
      std::cout << truevalue << ' ' << z(0) << ' ' << filter.state()(0) << ' ' << truespeed << ' ' << filter.state()(1) << std::endl;
      
    }
  
return 0;
}