#include <iostream>
#include "kalman.h"
#include <stdlib.h>

double frand()
{
  return (double) rand() / (double) RAND_MAX;
}

/** esempio di un sistema monodimensionale del tipo:
 * 
 *  x' = a * x + w
 *  z = b * x + v
 * */
int main()
{
  kalman_filter<double, boost::numeric::ublas::matrix<double> > filter(1);
  linearized_predict<boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double> > predict(1);
  linearized_observe<boost::numeric::ublas::matrix<double>, boost::numeric::ublas::matrix<double> > observe(1,1);
  
  boost::numeric::ublas::vector<double> initial_state(1);
  boost::numeric::ublas::zero_matrix<double> initial_P(1);
  
  initial_state(0) = 0.0;
  
  filter.set(initial_state, initial_P);
  
  double truevalue = 10.0;
  
  predict.A(0,0) = 1.0;
  predict.Q(0,0) = 0.01; // low process noise
  
  observe.H(0,0) = 1.0; // direct state observation
  observe.R(0,0) = 1.0; // high observation noise
  
  double x = 0.0;
  double p = 0.0;
  while(1)
    {
      boost::numeric::ublas::vector<double> z(1);
      filter.predict(predict);
      
      truevalue += 0.01 * frand() - 0.005;  // < 0.1
      
//       x = x;
//       double k = p * 
      
      z(0) = truevalue + (0.5 * frand() - 0.25);
      
      filter.observe(observe, z, linear_compare<double>() );
      
      std::cout << truevalue << ' ' << z(0) << ' ' << filter.state()(0) << std::endl;
      
    }
  
return 0;
}