/*******************************************************************************
* This file is part of NMEA Tools
* Copyright (C) 2006,2012 Paolo Medici
* 
* VEL is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* VEL is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser Public License for more details.
* 
* You should have received a copy of the GNU Lesser Public License
* along with NMEA Tools.  If not, see <http://www.gnu.org/licenses/>.
*******************************************************************************/

#ifndef _NMEA_PARSER_H
#define _NMEA_PARSER_H

#include <stdint.h>

// a big number
#define  NMEA_MAXSAT  24

#define NMEA_MODE_AUTO      'A'
#define NMEA_MODE_MANUAL    'M'

#define NMEA_FIX_BAD        (1)
#define NMEA_FIX_2D         (2)
#define NMEA_FIX_3D         (3)

#define NMEA_SIG_BAD        (0)
#define NMEA_SIG_LOW        (1)
#define NMEA_SIG_MID        (2)
#define NMEA_SIG_HIGH       (3)

#define NMEA_SAT_INVALID    0xFF

/// information on single satellite
struct nmea_sat
{
    uint8_t    id;         ///< Satellite PRN number 
    uint8_t    in_use;     ///< Used in position fix 
    uint8_t    elv;        ///< Elevation in degrees (0 to 90)
    uint8_t    sig;        ///< Signal strength in dB (0 to 99)
    uint16_t   azimuth;    ///< Azimuth, degrees from true north (0 to 359)
};

// Bit mask for updated and valid

#define NMEA_TIME        0x0001
#define NMEA_DATE        0x0002
#define NMEA_FIX         0x0004
#define NMEA_SIG         0x0008
#define NMEA_HDOP        0x0010
#define NMEA_PDOP        0x0020
#define NMEA_VDOP        0x0040
#define NMEA_DIRECTION   0x0080
#define NMEA_SPEED       0x0100
#define NMEA_SATINVIEW   0x0200
#define NMEA_SATINFO     0x0400
#define NMEA_SAT_IN_USE  0x0800
#define NMEA_LATLON      0x1000
#define NMEA_ALTITUDE    0x2000
#define NMEA_GEOIDHEIGHT 0x4000
#define NMEA_DGPS        0x8000

/// fwd declaration. Embedded system must allocate it without memory management.
struct nmea_context;

/// nmea information provided by string
struct nmea_info {
       uint32_t valid;

// TIME
       uint32_t msec;       
       uint32_t sec;       
       uint32_t min;
       uint32_t hour;       
// DATE  
       uint32_t mday;
       uint32_t month;
       uint32_t year;
//      
       uint8_t fix;
       char    mode;
       uint8_t sig;
       double HDOP, PDOP, VDOP;
       double latitude, longitude, altitude;
       double geoidheight;
       double direction;
       double speed;
// SATINFO  
       uint8_t sat_info;
       nmea_sat sat[NMEA_MAXSAT];
       uint8_t sat_inuse;
       uint8_t sat_inview;      
// DGPS       
       uint16_t dgps_prn;
       double dgps_age;
      };

/// a nmea parser library
class nmea_parser: public nmea_info {
      nmea_context *ctx;
      public:
// public data 
       
       /// Read/Write cumulative update bit flag
       /// user can reset it when it want to watch data changes
       uint32_t updated;
       
       public:
              
       nmea_parser();
       ~nmea_parser();
       
       /// parse a single NMEA sentence. buffer will be destroyed.
       /// updated and valid are updated according to parsed data
       bool parse(char *str);
      
      };

#endif

