#include<stdio.h>
#include<stdlib.h>
#include"pp.h"
#include"bbox.h"
#include"sym.h"
#include"die.h"
#include"ll.h"
#include"alloca.h"
#include"pgm.h"

#define BORD 4 /* bordo non valido causa pre-elaborazione */

/* codesta funzione calcola le simmetrie presenti nell'immagine
 * image e restituisce una catena di bounding box contenenti solo
 * le coordinate dei bounding box piu' promettenti */

struct bbox *calcola_simmetrie(unsigned char *image, unsigned char *filtered_image, char *nf)
{
  struct bbox *p, *base;
  unsigned short col, row, w, h;
  unsigned char a, b, Gp, Gm, dG;
  int cont_pixel_edge, cont_pixel_edge_symm, cont_pixel_alike, i, j;
  double symm_gray, symm_edge, symm_tot, max_symm_tot, bb_area;
  int row_max, h_max, w_max;   
  struct local_bb {
    unsigned short xo, yo;
    unsigned short w, h;
    double symm;
    };
  struct local_bb *gray, *edge, *prod;
	
  FILE *fp;
  
  double max_symm;
  unsigned short col_max, n;
  
  unsigned char *img, color;

  double max_symm_gray, max_symm_edge;
  double mg, me, mp;
  int row_max_gray, h_max_gray, w_max_gray, row_max_edge, h_max_edge, w_max_edge;
  int rg, re, rp, rt;
  

  /* controllo valori di ricerca bb */
  if (delta_riga > (riga-bby))
    die("attenzione: delta_riga > (riga-bby) !!!", "");
  if ((riga+delta_riga) >= yidim)
    die("attenzione: (riga+delta_riga) >= yidim !!!", "");
  if (delta_riga%step_riga)
    warn("warning: delta_riga non e` multiplo di step_riga !!!");
  if (delta_bbx%step_bbx)
    warn("warning: delta_bbx non e` multiplo di step_bbx !!!");
  if (delta_bby%step_bby)
    warn("warning: delta_bby non e` multiplo di step_bby !!!");
  if (bbx%2)
    warn("warning: bbx dovrebbe essere pari !!!");
  if (delta_bbx%2)
    warn("warning: delta_bbx dovrebbe essere pari !!!");
  if (step_bbx%2)
    warn("warning: step_bbx dovrebbe essere pari !!!");

  /* ocio! si potrebbe verificare */
  if (!image) return NULL;

  dG = 10;

  gray = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc gray");
  edge = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc edge");
  prod = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc prod");

  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
    max_symm_tot = 0;
    row_max = 0;
    h_max = 0;
    w_max = 0;
    max_symm_gray = 0;
    row_max_gray = 0;
    h_max_gray = 0;
    w_max_gray = 0;
    max_symm_edge = 0;
    row_max_edge = 0;
    h_max_edge = 0;
    w_max_edge = 0;
    for (row=riga-delta_riga; row<=riga+delta_riga; row+=step_riga) {
      for (h=bby-delta_bby*(row<riga ? 1:0); h<=bby+delta_bby*(row>=riga ? 1:0); h+=step_bby) {
	for (w=bbx-delta_bbx*(row<riga ? 1:0); w<=bbx+delta_bbx*(row>=riga ? 1:0); w+=step_bbx) {  
	  bb_area = (double) (w-2)*(h-1);
	  cont_pixel_alike = 0;
	  cont_pixel_edge = 0;
	  cont_pixel_edge_symm = 0;
	  for (i=row-h+1; i<=row-1; i++) {
	    for (j=1; j<=(w-1)/2; j++) {
	      Gp = pick(image, xidim, i, col-j);
	      Gm = pick(image, xidim, i, col+j);
	      if (abs(Gp-Gm)<dG) cont_pixel_alike+=2;
	      a = pick(filtered_image, xidim, i, col-j);
	      b = pick(filtered_image, xidim, i, col+j);
	      if (a&128) cont_pixel_edge++;
	      if (b&128) cont_pixel_edge++;
	      if ((a&128)&&(b&128)) cont_pixel_edge_symm+=2;
	      }
	    }
	  symm_gray = (cont_pixel_alike*cont_pixel_alike) / bb_area;
	  symm_gray = symm_gray * (cont_pixel_edge/bb_area);
	  if (cont_pixel_edge == 0) 
	    symm_edge = 0;
    	  else 
	    symm_edge = (cont_pixel_edge_symm*cont_pixel_edge_symm) / ((double) cont_pixel_edge);
	  symm_tot = symm_gray*symm_edge*(cont_pixel_edge/bb_area);
	  if (symm_tot > max_symm_tot) {
	    max_symm_tot = symm_tot;
	    row_max = row;
	    h_max = h;
	    w_max = w;
	    }	    
	  if (symm_gray > max_symm_gray) {
	    max_symm_gray = symm_gray;
	    row_max_gray = row;
	    h_max_gray = h;
	    w_max_gray = w;
	    }	    
	  if (symm_edge > max_symm_edge) {
	    max_symm_edge = symm_edge;
	    row_max_edge = row;
	    h_max_edge = h;
	    w_max_edge = w;
	    }	    
	  }
	}
      }
    prod[col].xo = col;
    prod[col].yo = row_max;
    prod[col].h = h_max;
    prod[col].w = w_max;
    prod[col].symm = max_symm_tot;
    gray[col].xo = col;
    gray[col].yo = row_max_gray;
    gray[col].h = h_max_gray;
    gray[col].w = w_max_gray;
    gray[col].symm = max_symm_gray;
    edge[col].xo = col;
    edge[col].yo = row_max_edge;
    edge[col].h = h_max_edge;
    edge[col].w = w_max_edge;
    edge[col].symm = max_symm_edge;
    }

    
  fp = Fopen("best_bb_per_col.txt", "w");
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) 
    fprintf(fp, "%hu %g\n", col, prod[col].symm);
  fclose(fp);

  img = Mallocm(3*xidim*yidim*sizeof(unsigned char),"allocazione img sym");
  /* memcpy(img, left_inimage, xidim*yidim*sizeof(unsigned char)); */
  for (i=0; i<xidim*yidim; i++)  
    img[i*3] = img[i*3+1] = img[i*3+2] = image[i];
  mg = 0;
  me  = 0;
  mp = 0;
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
    if (gray[col].symm > mg)
      mg = gray[col].symm;
    if (edge[col].symm > me)
      me = edge[col].symm;
    if (prod[col].symm > mp)
      mp = prod[col].symm;
    }
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
    rg = yidim-1 - gray[col].symm/mg*(yidim/2);
    re = yidim-1 - edge[col].symm/me*(yidim/2);
    rp = yidim-1 - prod[col].symm/mp*(yidim/2);
    if (rg<re && rg<rp) {
      for (i=yidim-1; i>=rg; i--) {
	img[3*(i*xidim+col)] = 255;
	img[3*(i*xidim+col)+1] = 0;
	img[3*(i*xidim+col)+2] = 0;
	}
      if (re < rp) {
	for (i=yidim-1; i>=re; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	for (i=yidim-1; i>=rp; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 255;
	  }
	}
      else {
	for (i=yidim-1; i>=rp; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 255;
	  }
	for (i=yidim-1; i>=re; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	}
      }
    if (re<rg && re<rp) {
      for (i=yidim-1; i>=re; i--) {
       	img[3*(i*xidim+col)] = 0;
	img[3*(i*xidim+col)+1] = 255;
	img[3*(i*xidim+col)+2] = 0;
	}
      if (rg < rp) {
	for (i=yidim-1; i>=rg; i--) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	for (i=yidim-1; i>=rp; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 255;
	  }
	}
      else {
	for (i=yidim-1; i>=rp; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 255;
	  }
	for (i=yidim-1; i>=rg; i--) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	}
      }
    if (rp<rg && rp<re) {
      for (i=yidim-1; i>=rp; i--) {
	img[3*(i*xidim+col)] = 0;
	img[3*(i*xidim+col)+1] = 0;
	img[3*(i*xidim+col)+2] = 255;
	}
      if (rg < re) {
	for (i=yidim-1; i>=rg; i--) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	for (i=yidim-1; i>=re; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	}
      else {
	for (i=yidim-1; i>=re; i--) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	for (i=yidim-1; i>=rg; i--) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	}
      }
    rt = yidim-1 - (mp ? ts*(yidim/2)/mp : 0);
    img[3*(rt*xidim+col)] = 0;
    img[3*(rt*xidim+col)+1] = 255;
    img[3*(rt*xidim+col)+2] = 255;
    }
  n = 0; 
  base = NULL;
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc)
    if (prod[col].symm < ts)
      prod[col].symm = 0;
  max_symm = 1;
  while (max_symm != 0) {
    max_symm = 0;
    col_max = 0;
    for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc)
      if (prod[col].symm > max_symm) {
	col_max = col;
	max_symm = prod[col].symm;
	}
    if (max_symm > 0) {
      for (col=col_max-prod[col_max].w/2; col<=col_max+prod[col_max].w/2; col++)
	prod[col].symm = 0;
      p = alloc_bbox();
      p->xc = prod[col_max].xo;
      p->yc = prod[col_max].yo;
      p->xsize = prod[col_max].w;
      p->ysize = prod[col_max].h;
      p->next = base;
      base = p;
      n++;
      }
    }
  
#ifdef PPDEBUG
  printf("\nSoglia simmetria: %g\n",ts);
  fprintf(stderr, "bb trovati dal peggiore al migliore:\n");
#endif
  color = 0;
  p = base;
  while (p != NULL) {
    for (j=p->xc-p->xsize/2; j<=p->xc+p->xsize/2; j++) {
      /* pick(img, xidim, p->yc-p->ysize, j) = color; */
      img[3*((p->yc-p->ysize)*xidim+j)]=img[3*((p->yc-p->ysize)*xidim+j)+1]=img[3*((p->yc-p->ysize)*xidim+j)+2] = color;
      /* pick(img, xidim, p->yc, j) = color; */
      img[3*((p->yc)*xidim+j)]=img[3*((p->yc)*xidim+j)+1]=img[3*((p->yc)*xidim+j)+2] = color;
      }
    for (i=p->yc-p->ysize; i<=p->yc; i++) {
      /* pick(img, xidim, i, p->xc-p->xsize/2) = color; */
      img[3*(i*xidim+(p->xc-p->xsize/2))]=img[3*(i*xidim+(p->xc-p->xsize/2))+1]=img[3*(i*xidim+(p->xc-p->xsize/2))+2] = color;
      /* pick(img, xidim, i, p->xc+p->xsize/2) = color; */
      img[3*(i*xidim+(p->xc+p->xsize/2))]=img[3*(i*xidim+(p->xc+p->xsize/2))+1]=img[3*(i*xidim+(p->xc+p->xsize/2))+2] = color;
      }
    if (n == 1)
      break;
    color += 256/(n-1)-1;
#ifdef PPDEBUG
    fprintf(stderr, "xc = %3hu  yc = %3hu  xsize = %3hu  ysize = %3hu\n", p->xc, p->yc, p->xsize, p->ysize);
#endif
    p = p->next;
    }

  write_pnm(nf, img, xidim, yidim);
  free(img);
  
  return base;
}

