#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<strings.h>
#include<math.h>
#define _GNU_SOURCE
#include"getopt.h"
#include"pp.h"
#include"ll.h"
#include"die.h"
#include"alloca.h"
#include"pgm.h"

extern char *optarg;

/* maschera per filtrare via i punti isolati */
int morph[]={1,1,1,
             1,0,1,
	     1,1,1};



#undef DEBUGPARAM
#define ML_P 200 /* massima lunghezza parametri */
/* legge una riga dal file e restituisce numero valori letti */	     
char *param_int[]=   {"XIDIM", "YIDIM"};
int *param_int_var[]={(int*)&xidim,  (int*)&yidim};

int leggi_riga_int(FILE *p){ 
  int ii,j;
  char param[ML_P];
  char tparam[ML_P];
  char c;
  int NP_N;


  NP_N=sizeof(param_int)/sizeof(*param_int);

  c=' ';
  while((c==' ')||(c=='\n'))c=getc(p);
  ungetc((int)c,p);

  ii=fscanf(p,"%[^' ']",param); 
#ifdef DEBUGPARAM
  fprintf(stderr, "Parametro in esame %s\n",param);
#endif
  if((ii!=1) || (!strcmp(param, "END"))){
    return 0;
  }
  for (ii=0;ii<NP_N;++ii) {
    if(!strcasecmp(param,param_int[ii])){
      c=' ';
      while((c==' ')||(c=='='))
	c=getc(p);
      ungetc((int)c,p);
      j=fscanf(p,"%[^\n]",tparam);
      if(j!=1){
	fprintf(stderr, "Errore di sintassi per il parametro %s\n",param);
	return 0;
      }
#ifdef DEBUGPARAM
      fprintf(stderr, "associo valore %d a parametro %s\n",atoi(tparam),param);
#endif
      *(param_int_var[ii])=atoi(tparam);
    }
  }
  fscanf(p,"%[^\n]\n",tparam);
  return 1;
}

char *param_ushort[]=   {"riga", "delta_riga", "step_riga", "bbx", "delta_bbx", "step_bbx", "bby", "delta_bby", "step_bby", "step_xc"};
unsigned short *param_ushort_var[]={&riga,  &delta_riga,  &step_riga,  &bbx,  &delta_bbx,  &step_bbx,  &bby,  &delta_bby,  &step_bby,  &step_xc};

int leggi_riga_ushort(FILE *p){
  int ii,j;
  char param[ML_P];
  char tparam[ML_P];
  char c;
  int NP_N;


  NP_N=sizeof(param_ushort)/sizeof(*param_ushort);

  c=' ';
  while((c==' ')||(c=='\n'))c=getc(p);
  ungetc((int)c,p);

  ii=fscanf(p,"%[^' ']",param); 
#ifdef DEBUGPARAM
  fprintf(stderr, "Parametro in esame %s\n",param);
#endif
  if((ii!=1) || (!strcmp(param, "END"))){
    return 0;
  }
  for (ii=0;ii<NP_N;++ii) {
    if(!strcasecmp(param,param_ushort[ii])){
      c=' ';
      while((c==' ')||(c=='='))
	c=getc(p);
      ungetc((int)c,p);
      j=fscanf(p,"%[^\n]",tparam);
      if(j!=1){
	fprintf(stderr, "Errore di sintassi per il parametro %s\n",param);
	return 0;
      }
#ifdef DEBUGPARAM
      fprintf(stderr, "associo valore %d a parametro %s\n",atoi(tparam),param);
#endif
      *(param_ushort_var[ii])=(unsigned short)atoi(tparam);
    }
  }
  fscanf(p,"%[^\n]\n",tparam);
  return 1;
}
/* inizializzazioni variabili, lettura file, allocazioni... 
 * XXX e' un'unica funzione, forse meglio spezzare */
void inizializza(int argc, char **argv){
  char ch;
  FILE *init_file;
  char *init_file_name;
  float xf=1, yf=1;

  /* inizializzazione variabili globali*/
  left_infile="in.pgm";
  right_infile=NULL;
  is_stereo=0;
  outfile="out.pgm";
  right_inimage=left_inimage=outimage=tmpimage=NULL;
  xidim=384;
  yidim=288;
  init_file_name="pp.ini";
  th=10;
  ft=4;
  ts=800;

  /* lettura switch comando */
  /* OCCHIO: deve essere EOF su linux, e 255 su IBM ! */
  while ((ch = Getopt(argc, argv, "l:r:i:x:y:o:t:s:h")) != EOF){   
    switch(ch){
      case 'l': /* file in ingresso */
	left_infile=optarg;
	break;
      case 'r': /* file in ingresso */
	right_infile=optarg;
	is_stereo=1;
	break;
      case 'i': /* file opzioni */
	init_file_name=optarg;
	break;
      case 'o': /* file in uscita */
	outfile=optarg;
	break;
      case 'x': /* fattore scala x */
	xf=atof(optarg);
	break;
      case 'y': /* fattore scala y */
	yf=atof(optarg);
	break;
      case 't': /* fattore scala soglia */
	ft=atof(optarg);
	break;
      case 's': /* soglia simmetria */
	ts=atof(optarg);
	break;
      case 'h': /* help */
	printf("%s utilizzo:\n", argv[0]);
	printf(" -l <file>       immagine in ingresso (sinistra se stereo abilitato)\n");
	printf(" -r <file>       immagine destra in ingresso (implica stereo)\n");
	printf(" -o <file>       immagine in uscita\n");
	printf(" -i <file>       file opzioni (default %s)\n",init_file_name);
	printf(" -x <nn>         fattore scala x\n");
	printf(" -y <nn>         fattore scala y\n");
	printf(" -t <nn>         fattore scala soglia (default 4)\n");
	printf(" -s <nn>         soglia simmetria (default 800)\n");
	printf(" -h              sommario opzioni\n");
	exit(EXIT_SUCCESS);
      default:
	break;
    }
  }

  /* apertura e lettura file parametri */
  init_file=Fopen(init_file_name,"r");
  while(leggi_riga_int(init_file));
  rewind(init_file);
  while(leggi_riga_ushort(init_file));
  fclose(init_file);
  
  /* aggiustamenti linea comando */
  xidim*=xf;
  yidim*=yf;

  /* lettura file pgm in inimage */
  left_inimage=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione left_inimage");
  left_thin=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione left_thin");
  left_Nthin=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione left_Nthin");
  read_pgm_and_fit(left_inimage, xidim, yidim, left_infile);
  /* eliminazione pixel aventi valore 0,1,2,3*/
  ll_swappixelvalue(left_inimage, xidim, yidim, 0, 4);
  ll_swappixelvalue(left_inimage, xidim, yidim, 1, 4);
  ll_swappixelvalue(left_inimage, xidim, yidim, 2, 4);
  ll_swappixelvalue(left_inimage, xidim, yidim, 3, 4);

  if(right_infile){
    right_inimage=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione right_inimage");
    right_thin=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione right_thin");
    right_Nthin=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione right_Nthin");
    read_pgm_and_fit(right_inimage, xidim, yidim, right_infile);
    ll_swappixelvalue(right_inimage, xidim, yidim, 0, 4);
    ll_swappixelvalue(right_inimage, xidim, yidim, 1, 4);
    ll_swappixelvalue(right_inimage, xidim, yidim, 2, 4);
    ll_swappixelvalue(right_inimage, xidim, yidim, 3, 4);
  }


  /* allocazione immagine temporanea*/
  tmpimage=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione tmpimage");
  /* allocazione immagine finale risultato */
  /* outimage=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione outimage"); */
}

/* binarizzazione */
void preprocessa(unsigned char *inimage, unsigned char *thinned, unsigned char *not_thinned){
/* unsigned char *preprocessa(unsigned char *inimage){  */
  unsigned char *tmp, *tmpimage;
  float s;
  int nt;

  tmp=Callocm(xidim*yidim, sizeof(unsigned char), "allocazione immagine tmp in preprocessa");
  tmpimage=Callocm(xidim*yidim, sizeof(unsigned char), "allocazione immagine tmpimage in preprocessa");

  /* calcola media ed enhancement dei bordi XXX MA QUANTE ITERAZIONE SERVONO ??*/

  /*
  ll_media(inimage, tmp, xidim, yidim); 
  for (ii=0;ii<4;++ii) 
    ll_media(tmp,tmp,xidim, yidim);
  ll_media(tmp, tmpimage, xidim, yidim);
  */
  ll_media(inimage, tmpimage, xidim, yidim);  /* qui ne faccio solo una! */

  memset(tmp,0,sizeof(unsigned char)*xidim*yidim);
  
  s=ll_trova_soglia_per_fetta(tmpimage, xidim, yidim, riga, bbx);
  nt=s*ft+0.5f;

#ifdef PPDEBUG 
  printf("Soglia binarizzazione: %d\n",nt);
#endif

  ll_bordi_RAS_vert(tmpimage, tmp, xidim, yidim, 128, nt);
  ll_bordi_RAS_hor(tmpimage, tmp, xidim, yidim, 64, nt);
  memcpy(not_thinned,tmp,xidim*yidim);
#ifdef PPDEBUG 
  write_pgm("bordi.pgm",tmp,xidim, yidim); 
#endif
  ll_fake_thinning(tmp,tmp,xidim, yidim);
  ll_elimina_quasi_isolati(tmp,tmp,xidim,yidim,1);

  /* calcolo edge verticali (255)
  ll_vertical_edges(inimage, tmp, xidim, yidim, 128);
  ll_horizontal_edges(inimage, tmp, xidim, yidim, 64);

   elimino punti isolati 
  ll_elimina_quasi_isolati(tmp,tmp,xidim,yidim,1);

   elimino spuntoni 
  ll_eliminaspuntoni(tmp,tmp,xidim,yidim);
  ll_eliminaspuntoni_di_due(tmp,tmp,xidim,yidim);*/


  /* elimino bordi (3)*/
  ll_setborder(tmp,tmp,xidim,yidim,3,0);
#ifdef PPDEBUG 
  write_pgm("thin.pgm",tmp,xidim, yidim); 
#endif
  memcpy(thinned,tmp,xidim*yidim);
  free(tmpimage);
  free(tmp);
}



