#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#ifndef __USE_BSD
 #define __USE_BSD
#endif
#include<math.h>
#include"die.h"
#include"ll.h"
#include"alloca.h"
#include"pgm.h"


/* gia' incluso da math.h quando si #definisce __USE_BSD */
/* #define M_PI               3.14159265358979323846  */

/* prototipi interni */
int ll_comparachar(const void *, const void *);



/* qui dentro ci dovrebbero stare solo le orutine di low level image processing */

/* uso interno */
int ll_comparachar(const void *a, const void *b){
  if(*((unsigned short*)a)==*((unsigned short*)b)) return 0;
  if(*((unsigned short*)a)>*((unsigned short*)b)) return 1;
  return -1;
}

/* filtro mediana */
void ll_median_filter(unsigned char * dest, unsigned char * source, int x, int y, int wsize){
  int ix,iy,ii,lx,ly=0;
  unsigned char *values;
  values = Mallocm(wsize*wsize,"ll_median_filter");

  if(!wsize%2)
    die("Not odd number in median_filter() wsize","");
  ii=wsize/2;


  memset(dest, 0, x*y*sizeof(unsigned char));

  for(ix=ii;ix<x-ii;++ix)for(iy=ii;iy<y-ii;++iy){
   for(lx=-ii;lx<=ii;++lx)for(ly=-ii;ly<=ii;++ly)
     values[(lx+ii)+(ly+ii)*wsize]=source[ix+lx+(iy+ly)*x];
   qsort(values,wsize*wsize,sizeof(unsigned char),ll_comparachar);
   dest[ix+iy*x]=values[wsize*wsize/2];
  }
  free(values);
}

/* filtro mediana, ma non si considerano gli zeri */
void ll_median_filter_no0(unsigned char * dest, unsigned char * source, int x, int y, int wsize){
  int ix,iy,ii,lx,ly=0,np,v;
  unsigned char *values;
  values = Mallocm(wsize*wsize,"ll_median_filter_no0");

  if(!wsize%2)
    die("Not odd number in median_filter() wsize","");
  ii=wsize/2;

  memset(dest, 0, x*y*sizeof(unsigned char));

  for(ix=ii;ix<x-ii;++ix)for(iy=ii;iy<y-ii;++iy){
   if(!source[ix+iy*x])
     continue;
   np=0;
   for(lx=-ii;lx<=ii;++lx)for(ly=-ii;ly<=ii;++ly)
     if((v=source[ix+lx+(iy+ly)*x]))
       values[np++]=v;
   if(np){
     qsort(values,np,sizeof(unsigned char),ll_comparachar);
     dest[ix+iy*x]=values[(np-1)/2];
   }
  }
  free(values);
}



/* calcola la media 3x3 ed esalta i bordi */
void ll_media(unsigned char  *input, unsigned char *output, int xidim, int yidim)
{
        register int i, j, k;
        unsigned char pix, vicinato[9], differenze[9], max_diff;
        float avg, somma_pesi, peso;    
	unsigned char *avg_img;

	avg_img=Mallocm(xidim*yidim*sizeof(unsigned char),"allocazione immagine temporanea per media()");

        for(i = 1; i < yidim-1; i++)
        {
                for(j = 1; j < xidim-1; j++)
                {
                        pix = pick(input, xidim, i, j);

                        vicinato[0] = pick(input, xidim, i-1, j-1);
                        differenze[0] = abs(pix - vicinato[0]);

                        vicinato[1] = pick(input, xidim, i-1, j);
                        differenze[1] = abs(pix -vicinato[1]);

                        vicinato[2] = pick(input, xidim, i-1, j+1);
                        differenze[2] = abs(pix -vicinato[2]);
                        
                        vicinato[3] = pick(input, xidim, i, j-1);
                        differenze[3] = abs(pix -vicinato[3]);

                        vicinato[4] = pix;
                        differenze[4] = 0;

                        vicinato[5] = pick(input, xidim, i, j+1);
                        differenze[5] = abs(pix -vicinato[5]);                 

                        vicinato[6] = pick(input, xidim, i+1, j-1);
                        differenze[6] = abs(pix -vicinato[6]);

                        vicinato[7] = pick(input, xidim, i+1, j);
                        differenze[7] = abs(pix -vicinato[7]);

                        vicinato[8] = pick(input, xidim, i+1, j+1);
                        differenze[8] = abs(pix -vicinato[8]);

                        for (k = 1, max_diff = differenze[0]; k <= 8; k++)
                        {
                                if (max_diff < differenze[k])
                                        max_diff = differenze[k];
                        }

                        if (max_diff != 0)
                        {
                          avg = 0.0f;
                          somma_pesi = 0.0f;
			  for (k = 0; k <= 8; k++){
                            peso = max_diff - differenze[k];
                            avg += vicinato[k]*peso;
                            somma_pesi += peso;
                          }
                          avg /= somma_pesi;
                          pick(avg_img, xidim, i, j) = ((unsigned char) (avg + 0.5));
                        }
                        else pick(avg_img, xidim, i, j) = pix;
                }
        }       
	memcpy(output,avg_img,xidim*yidim*sizeof(unsigned char));
	free(avg_img);
}

/* ritorna la soglia di riga, usata nella funzione successiva */
float ll_linear_treshold(unsigned char *input, int np){
        int i;
        unsigned int insat;            /* nb variations nvg hors saturation    */
        int iseuil;                      
        float s1, s2;                   
        int delta;                     
        unsigned int hist_cum;        
        int histo[256];        /* era      int histo[256]={};  */

	for (i=0;i<256;++i)histo[i]=0;

        for (i = np-1, insat = np-1; i > 0; i--) { 
                delta = abs((int)input[i] - (int)input[i-1]);
                if ((delta != 0) || ((input[i] != 0) && (input[i] != 255))) histo[delta]++;
                else insat--;
        }
        /*if (histo[0] == 0) return(0);*/
        if (histo[0] == 0) s1 = 0;
        else s1 = .4*(float)insat/(float)histo[0];
        iseuil = 68.0*insat/100.0;
        hist_cum = 0;
        for (i = 0; (hist_cum += histo[i]) < iseuil; i++);
        if (i == 0) s2 = 0;
        else s2 = (float)i - ((float)hist_cum - (float)iseuil)/(float)histo[i];
        return(1.4*(s1+s2));
}

/* calcola i bordi della riga puntata da buf e lunga nl usando come soglia seuil, esegue un OR logico fra value e
 * i corrispondenti pixel della riga puntata da dest */
void ll_elemcar(unsigned char *buf, unsigned char *dest, float seuil, int nl, const unsigned char value){
  /* nl numero pixel per linea */


  int i, j, k, ideb, ifin;
  int delta, delta1;
  long delta2;
  int sgn_seg, h_seg = 0;
  float som1, som2;
  int s_lmc, s_seg;
  int seuild, seuilf;
  int dist, dist_min;


  /* se la soglia e' nulla esco... a naso non capita mai */
  if (seuil == 0)
    return;

  /* azzero la riga in esame dell'immagine destinazione */
  /* memset(dest, 0, nl*sizeof(unsigned char));*/

  s_seg = (2 * seuil + .5f);
  s_lmc = (seuil / 2.8f + .5f);
  i = 0;
  sgn_seg = 0;
  for (j = 0; j < nl - 1; j++)
    {
      delta = (int) buf[j + 1] - (int) buf[j];
      if (delta * sgn_seg > 0)
	continue;
      h_seg = (int) buf[j] - (int) buf[i];
      if (abs (h_seg) <= s_seg)
	{
	  i = j;
	  sgn_seg = delta;
	  continue;
	}
      if (h_seg > 0)
	{
	  if (i > 0)
	    seuild = 2 * (int) buf[i] - (int) buf[i - 1] + s_lmc;
	  else
	    seuild = (int) buf[i] + s_lmc;
	  seuilf = 2 * (int) buf[j] - (int) buf[j + 1] - s_lmc;
	}
      else
	{
	  if (i > 0)
	    seuild = 2 * (int) buf[i] - (int) buf[i - 1] - s_lmc;
	  else
	    seuild = (int) buf[i] - s_lmc;
	  seuilf = 2 * (int) buf[j] - (int) buf[j + 1] + s_lmc;
	}
      dist_min = abs (seuild - (int) buf[i]);
      for (ideb = i;; ideb++)
	{
	  if ((dist = abs ((int) buf[ideb + 1] - seuild)) >= dist_min)
	    break;
	  dist_min = dist;
	}
      dist_min = abs (seuilf - (int) buf[j]);
      for (ifin = j;; ifin--)
	{
	  if ((dist = abs ((int) buf[ifin - 1] - seuilf)) >= dist_min)
	    break;
	  dist_min = dist;
	}
      som1 = 0;
      som2 = 0;
      for (k = ideb; k < ifin; k++)
	{
	  delta1 = (int) buf[k + 1] - (int) buf[k];
	  delta2 = delta1 * delta1;
	  som2 += delta2;
	  som1 += delta2 * (k + .5);
	}
      dest[(int)(som1 / som2 + .5f)]|=value;
      i = j;
      sgn_seg = delta;
    }

  h_seg = (int) ((int) buf[j] - (int) buf[i]);
  if (abs (h_seg) <= s_seg)
    return;

  if (h_seg > 0)
    {
      seuild = 2 * (int) buf[i] - (int) buf[i - 1] + s_lmc;
      if (j < nl - 1)
	seuilf = 2 * (int) buf[j] - (int) buf[j + 1] - s_lmc;
      else
	seuilf = (int) buf[j] - s_lmc;
    }
  else
    {
      seuild = 2 * (int) buf[i] - (int) buf[i - 1] - s_lmc;
      if (j < nl - 1)
	seuilf = 2 * (int) buf[j] - (int) buf[j + 1] + s_lmc;
      else
	seuilf = (int) buf[j] + s_lmc;
    }
  dist_min = abs (seuild - (int) buf[i]);
  for (ideb = i;; ideb++)
    {
      if ((dist = abs ((int) buf[ideb + 1] - seuild)) >= dist_min)
	break;
      dist_min = dist;
    }
  dist_min = abs (seuilf - (int) buf[j]);
  for (ifin = j;; ifin--)
    {
      if ((dist = abs ((int) buf[ifin - 1] - seuilf)) >= dist_min)
	break;
      dist_min = dist;
    }
  som1 = 0;
  som2 = 0;
  for (k = ideb; k < ifin; k++)
    {
      delta1 = (int) buf[k + 1] - (int) buf[k];
      delta2 = delta1 * delta1;
      som2 += delta2;
      som1 += delta2 * (k + .5);
    }
  dest[(int)(som1 / som2 + .5f)]|=value;
}

/* in corrispondenza degli edge verticali di orig dest|=value */
void ll_vertical_edges(unsigned char *orig, unsigned char *dest, int x, int y, const unsigned char value){
  int ii;
  float th;

  
  for(ii=0;ii<y;++ii){
    th=ll_linear_treshold(&orig[ii*x],x);
    /*print("%d-%g\n",ii,th);*/
    ll_elemcar(&orig[ii*x], &dest[ii*x], th, x, value);
  }
}

/* in corrispondenza degli edge orizzontali di orig dest|=value */
void ll_horizontal_edges(unsigned char *orig, unsigned char *dest, int x, int y, const unsigned char value){
  int ii,jj;
  float th;
  unsigned char *hline, *tmpline;
  
  hline=Mallocm(y*sizeof(unsigned char),"ll_horizontal_edges");
  tmpline=Mallocm(y*sizeof(unsigned char),"ll_horizontal_edges");

  for(ii=0;ii<x;++ii){
    for(jj=0;jj<y;++jj)
      hline[jj]=orig[ii+jj*x];
    th=ll_linear_treshold(hline,y);
    memset(tmpline,0,y*sizeof(unsigned char));
    ll_elemcar(hline, tmpline, th, y, value);
    for(jj=0;jj<y;++jj)
      dest[ii+jj*x]|=tmpline[jj];
  }
  free(hline);free(tmpline);

}

/* elimina i punti isolati secondo la maschera di dimensioni masksize*masksize*/
void ll_eliminamaschera(const unsigned char *orig, unsigned char *destinaz, const int x, const int y, const int *mask, const int masksize, const int n){
  int ii, ix,iy,lx,ly;
  int losalvo=0;
  unsigned char *dest;

  if(!masksize%2)
    die("maschera non dispari in ll_eliminaisolati","");
  ii=masksize/2;

  dest=Callocm(x*y,sizeof(unsigned char),"ll_eliminaisolati");

  for(ix=ii;ix<x-ii;++ix)for(iy=ii;iy<y-ii;++iy){
   losalvo=0;
   for(lx=-ii;lx<=ii;++lx)for(ly=-ii;ly<=ii;++ly)
     if(mask[(lx+ii)+(ly+ii)*masksize]*orig[ix+lx+(iy+ly)*x])
       ++losalvo;
   if(losalvo>=n)
     dest[ix+iy*x]=orig[ix+iy*x];
  }
  memcpy(destinaz,dest,x*y*sizeof(unsigned char));
  free(dest);
}

/* elimina gli spuntoni, ovverossia controlla il vicinato ed elimina i punti che hanno due o piu' vicini
 * gia' connessi tra di loro e che non sono ponte tra vicini */
void ll_eliminaspuntoni(unsigned char *orig, unsigned char *destinaz, int x, int y){
  unsigned char *dest;
  int ix,iy,ii;
  unsigned char vicinato[8];
  int contiguo, fronti;

  dest=Callocm(x*y,sizeof(unsigned char),"ll_eliminaspuntoni");

  for(ix=1;ix<(x-1);++ix)for(iy=1;iy<(y-1);++iy){
   vicinato[0]=orig[(ix-1)+(iy-1)*x];
   vicinato[1]=orig[(ix)+(iy-1)*x];
   vicinato[2]=orig[(ix+1)+(iy-1)*x];
   vicinato[3]=orig[(ix+1)+(iy)*x];
   vicinato[4]=orig[(ix+1)+(iy+1)*x];
   vicinato[5]=orig[(ix)+(iy+1)*x];
   vicinato[6]=orig[(ix-1)+(iy+1)*x];
   vicinato[7]=orig[(ix-1)+(iy)*x];
   fronti=contiguo=0;
   for(ii=1;ii<8;++ii){
     if(vicinato[ii]&&vicinato[ii-1])contiguo++;
     if(vicinato[ii]&&!vicinato[ii-1])fronti++;
   }
   if(vicinato[0]&&!vicinato[7])fronti++;
   if(vicinato[0]&&vicinato[7])contiguo++;
   dest[ix+iy*x]=((!contiguo)||(fronti>1))?orig[ix+iy*x]:0;
  }

  memcpy(destinaz,dest,x*y*sizeof(unsigned char));
  free(dest);
}

/* elimina i pixel che nel vicinato 3x3 hanno meno di n pixel accesi */
void ll_elimina_quasi_isolati(unsigned char *orig, unsigned char *destinaz, int x, int y, int n){
  unsigned char *dest;
  int ix,iy,ii,np;
  unsigned char vicinato[8];

  dest=Callocm(x*y,sizeof(unsigned char),"ll_eliminaquasiisolati");
  for(ix=1;ix<(x-1);++ix)for(iy=1;iy<(y-1);++iy){
   vicinato[0]=orig[(ix-1)+(iy-1)*x];
   vicinato[1]=orig[(ix)+(iy-1)*x];
   vicinato[2]=orig[(ix+1)+(iy-1)*x];
   vicinato[3]=orig[(ix+1)+(iy)*x];
   vicinato[4]=orig[(ix+1)+(iy+1)*x];
   vicinato[5]=orig[(ix)+(iy+1)*x];
   vicinato[6]=orig[(ix-1)+(iy+1)*x];
   vicinato[7]=orig[(ix-1)+(iy)*x];
   for(np=0,ii=0;ii<8;++ii)
     if(vicinato[ii])++np;
   if(np<n) 
     dest[ix+iy*x]=0;
   else
     dest[ix+iy*x]=orig[ix+iy*x];
  }
 
  memcpy(destinaz,dest,x*y*sizeof(unsigned char));
  free(dest);
}

/* NON FA la differenza, ma dove a!=b restituisce a */
unsigned char  *ll_diff(const unsigned char *a, const unsigned char *b, const int x, const int y){
  int ii;
  unsigned char *tmp;

  tmp=Callocm(x*y,sizeof(unsigned char),"ll_diff");

  for(ii=0;ii<x*y;++ii)
    if(a[ii]!=b[ii])
      tmp[ii]=a[ii];

  return tmp;
}

/* dove a e' == 0 prende il valore di b, mette il risultato in a */
void ll_merge(unsigned char *a, unsigned char *b, const int x, const int y){
  int ii;

  for(ii=0;ii<x*y;++ii)if(!a[ii])a[ii]=b[ii];

}

void ll_eliminaspuntoni_di_due(unsigned char *orig, unsigned char *destinaz, int x, int y){
  unsigned char *isolati, *dest, *tmp;

  dest=Mallocm(x*y*sizeof(unsigned char),"ll_eliminaspuntoni_di_due");
  tmp=Mallocm(x*y*sizeof(unsigned char),"ll_eliminaspuntoni_di_due");
   
  /* elimino punti con singolo vicino e pongo in dest */
  ll_elimina_quasi_isolati(orig,dest,x,y,2);
  /* calcolo delta tra le due immagini, sono punti singoli */
  isolati=ll_diff(orig,dest,x,y);

  /* elimino spuncioni singoli e li pongo in tmp */
  ll_eliminaspuntoni(dest,tmp,x,y);

  /* mischio il risultato con i punti di testa */
  ll_merge(tmp,isolati,x,y);
  ll_elimina_quasi_isolati(tmp,tmp,x,y,1);

  memcpy(destinaz,tmp,x*y*sizeof(unsigned char));
  free(dest);
  free(isolati);
  free(tmp);
}

/* mi pone il bordo dell'immagine di spessore size ad un certo valore v */
void ll_setborder(unsigned char *orig, unsigned char *destinaz, int x, int y, int size, unsigned char v){
  int ix, iy, i;


  memmove(destinaz,orig,x*y*sizeof(unsigned char));

  for(ix=0;ix<x;++ix)
    for(i=0;i<=size;i++){
      destinaz[ix+i*x]=v;
      destinaz[ix+(y-i-1)*x]=v;
    }

  for(iy=size;iy<(y-size);++iy)
    for(i=0;i<=size;i++){
      destinaz[i+iy*x]=v;
      destinaz[x-i-1+iy*x]=v;
    }
}

/* cherca tutti i pixel di valore a e ci sostituisce il valore b */
void ll_swappixelvalue(unsigned char *work, int x, int y, unsigned char a, unsigned char b){
  int ii;
  for(ii=0;ii<x*y;++ii)
    if(work[ii]==a)work[ii]=b;
}


/* interpolazione bilineare (in realta' funziona solo per ridurre!) */
void ll_bilinear_interpolation(unsigned char *dest, int xnew, int ynew, unsigned char *orig, int xorig, int yorig){
  float scalex, scaley;
  int ix, iy;
  float u,v,dv,du;
  int iu,iv;

  scalex=xorig/(float)xnew;
  scaley=yorig/(float)ynew;

  for(ix=0;ix<xnew;++ix)for(iy=0;iy<ynew;++iy){
    iu=u=scalex*ix;
    iv=v=scaley*iy;
    du=u-iu;
    dv=v-iv;
    dest[ix+iy*xnew]=orig[iu+iv*xorig]*(1-du)*(1-dv);
    if((iu+1)<xorig)
      dest[ix+iy*xnew]+= orig[iu+1+iv*xorig]*(du)*(1-dv);
    if(((iu+1)<xorig)&&((iv+1)<yorig))
      dest[ix+iy*xnew]+= orig[iu+1+(iv+1)*xorig]*(du)*(dv);
    if((iv+1)<yorig)
      dest[ix+iy*xnew]+= orig[iu+(iv+1)*xorig]*(1-du)*(dv);
  }


}



void ll_bordi_RAS_vert(unsigned char *avg_img, unsigned char *dest, int xidim, int yidim, unsigned char v, unsigned int soglia){
  int i,j;
  int a, b, c, d, e, f, g, l;
  float comp_x, comp_y, mod, fase;

  for (i = 2; i < yidim - 2; i++) for (j = 2; j < xidim - 2; j++) { 
    /* pick(modulo1, xidim, i, j) = 0;*/

    a = (int) pick(avg_img, xidim, i-1, j-1);
    b = (int) pick(avg_img, xidim, i-1, j);
    c = (int) pick(avg_img, xidim, i-1, j+1);
    d = (int) pick(avg_img, xidim, i, j-1);
    e = (int) pick(avg_img, xidim, i, j+1);
    f = (int) pick(avg_img, xidim, i+1, j-1);
    g = (int) pick(avg_img, xidim, i+1, j);
    l = (int) pick(avg_img, xidim, i+1, j+1);
    /* filtro o di Sobel */
    comp_x = ((float)((a - c) + 2 * (d - e) + (f - l))) / 4.0f;
    comp_y = ((float)((a - f) + 2 * (b - g) + (c - l))) / 4.0f;

    mod = sqrt(comp_x * comp_x + comp_y * comp_y);

     if (comp_x != 0)
      fase = atan(comp_y/comp_x);
    else 
      fase = M_PI/2;
    if ((mod>soglia)&&(fase<M_PI/4)&&(fase>-M_PI/4))
      dest[i*xidim+j]|=v;
  }
}

void ll_bordi_RAS_hor(unsigned char *avg_img, unsigned char *dest, int xidim, int yidim, unsigned char v, unsigned int soglia){
  int i,j;
  int a, b, c, d, e, f, g, l;
  float comp_x, comp_y, mod, fase;

  for (i = 2; i < yidim - 2; i++) for (j = 2; j < xidim - 2; j++) { 
    /* pick(modulo1, xidim, i, j) = 0;*/

    a = (int) pick(avg_img, xidim, i-1, j-1);
    b = (int) pick(avg_img, xidim, i-1, j);
    c = (int) pick(avg_img, xidim, i-1, j+1);
    d = (int) pick(avg_img, xidim, i, j-1);
    e = (int) pick(avg_img, xidim, i, j+1);
    f = (int) pick(avg_img, xidim, i+1, j-1);
    g = (int) pick(avg_img, xidim, i+1, j);
    l = (int) pick(avg_img, xidim, i+1, j+1);
    /* filtro o di Sobel */
    comp_x = ((float)((a - c) + 2 * (d - e) + (f - l))) / 4.0f;
    comp_y = ((float)((a - f) + 2 * (b - g) + (c - l))) / 4.0f;

    mod = sqrt(comp_x * comp_x + comp_y * comp_y);

     if (comp_x != 0)
      fase = atan(comp_y/comp_x);
    else 
      fase = M_PI/2;
    if ((mod>soglia)&&!((fase<M_PI/4)&&(fase>-M_PI/4)))
      dest[i*xidim+j]|=v;
  }
}



/* scheletrizzazione (usando maschera 3x3) */
void ll_thinning(unsigned char *orig, unsigned char *dest, int x, int y){
  unsigned char *tmp, *Orig;
  int ix,iy,lx,ly, mi;
  char spegni=1, ch;
  int mask[8][3][3]={{{ 0, 0, 8},
                      { 0, 1, 1},
	       	      { 8, 1, 8}},

                     {{ 0, 0, 0},
		      { 8, 1, 8},
		      { 1, 1, 8}},
  
                     {{ 8, 0, 0},
		      { 1, 1, 0},
		      { 8, 1, 8}},
  
                     {{ 1, 8, 0},
		      { 1, 1, 0},
		      { 8, 8, 0}},
                     
                     {{ 8, 1, 8},
		      { 1, 1, 0},
		      { 8, 0, 0}},
		     
		     {{ 8, 1, 1},
		      { 8, 1, 8},
		      { 0, 0, 0}},
  
                     {{ 8, 1, 8},
		      { 0, 1, 1},
		      { 0, 0, 8}},
  
                     {{ 0, 8, 8},
		      { 0, 1, 1},
		      { 0, 8, 1}}};

  Orig=Mallocm(x*y,"ll_thinning");
  tmp=Mallocm(x*y,"ll_thinning");
  memcpy(Orig,orig,x*y);
  memcpy(tmp, orig, x*y);

  ch=1;
  while(ch){
    ch=0;
    for(ix=1;ix<x-1;++ix)for(iy=1;iy<y-1;++iy){
      for(mi=0;(mi<8)&&(!ch);++mi){
	spegni=1;
	for(ly=-1;(ly<=1)&&spegni;++ly)for(lx=-1;(lx<=1)&&spegni;++lx){
	  if((Orig[ix+lx+x*(iy+ly)])&&(mask[mi][ly+1][lx+1]==0))
	    spegni=0;
	  if((!Orig[ix+lx+x*(iy+ly)])&&(mask[mi][ly+1][lx+1]==1))
	    spegni=0;
	}
	if(spegni){
	  tmp[ix+iy*x]=0;
	  ch=1;
	}
      }
    }
    memcpy(Orig, tmp, x*y);
  }

  memcpy(dest,Orig,x*y*sizeof(unsigned char));
  free(tmp);
  free(Orig);
}


/* falsa scheletrizzazione */
void ll_fake_thinning(unsigned char *orig, unsigned char *dest, int x, int y){
  unsigned char *h, *v;
  int ix,iy;

  h=Callocm(x*y,1,"ll_thinning");
  v=Callocm(x*y,1,"ll_thinning");
  /* scheletrizzo orizzontalmente */
  for(iy=0;iy<y;++iy)
    for(ix=0;ix<x-1;++ix)
      if((orig[ix+iy*x]&128)&&!orig[ix+1+iy*x])
	h[ix+iy*x]=orig[ix+iy*x];



  /* e poi verticalmente */
  for(ix=0;ix<x;++ix)
    for(iy=0;iy<y-1;++iy)
      if((orig[ix+iy*x]&64)&&!orig[ix+(iy+1)*x])
	v[ix+iy*x]=orig[ix+iy*x];

  for(ix=0;ix<x*y;++ix)v[ix]|=h[ix];
  free(h);
  memcpy(dest,v,x*y*sizeof(unsigned char));
  free(v);
}

float ll_trova_soglia_per_fetta(unsigned char *input, int x, int y, int linea_start, int num_linee){
  int ii;
  float avg;

  avg=0;
  for (ii=linea_start;ii<linea_start+num_linee;++ii){
    avg+=ll_linear_treshold(input+ii*x, x);
  }
  avg/=num_linee;

  return avg;
}
