#include<stdio.h>
#include<stdlib.h>
#include"pp.h"
#include"bbox.h"
#include"sym.h"
#include"die.h"
#include"ll.h"
#include"alloca.h"
#include"pgm.h"

#define BORD 4 /* bordo non valido causa pre-elaborazione */
/*#define COL 159  unica colonna su cui si vuole eseguire la ricerca di simmetrie */

void ordina(int vettore[], int lung);


/* codesta funzione calcola le simmetrie presenti nell'immagine
 * image e restituisce una catena di bounding box contenenti solo
 * le coordinate dei bounding box piu' promettenti */

struct bbox *calcola_simmetrie(unsigned char *image, unsigned char *filtered_image, char *nf)
{
  struct bbox *p, *base;
  unsigned short col, row, w, h;
  unsigned char a, b, Gp, Gm, dG;
  int cont_pixel_edge, cont_pixel_edge_symm, cont_pixel_alike, i, j;
  double symm_gray, symm_edge, density, symm_tot, max_symm_tot, bb_area;
  int row_max, h_max, w_max;   
  struct local_bb {
    unsigned short xo, yo;
    unsigned short w, h;
    double symm;
    };
  struct local_bb *gray, *edge, *prod, *dens;
	
  FILE *fp;
  
  double max_symm;
  unsigned short col_max, n;
  
  unsigned char *img, color;

  double max_symm_gray, max_symm_edge, max_dens;
  int row_max_gray, h_max_gray, w_max_gray, row_max_edge, h_max_edge, w_max_edge, row_max_dens, h_max_dens, w_max_dens;
  double mg, me, md, mp;
  int rg, re, rd, rp, rt, vett[4];

#ifdef COL
  double *sg, *se, *de, *pr, max_sg, max_se, max_de, max_pr;
  int dimx, dimy;
  unsigned char *isg, *ise, *ide, *ipr;
#endif

  
#ifdef COL
  riga = 112;
  delta_riga = 0;
  bbx = 28;
  delta_bbx = 20;
  step_bbx = 2;
  bby = 78;
  delta_bby = 20;
  step_bby = 2;
#endif

  /* controllo valori di ricerca bb */
  if ((riga+delta_riga) >= yidim)
    die("attenzione: (riga+delta_riga) >= yidim !!!", "");
  if (bby > (riga-delta_riga))
    die("attenzione: bby > (riga-delta_riga) !!!", "");
  if (bby+delta_bby > riga)
    die("attenzione: bby+delta_bby > riga !!!", "");
  if (delta_riga%step_riga)
    warn("warning: delta_riga non e` multiplo di step_riga !!!");
  if (delta_bbx%step_bbx)
    warn("warning: delta_bbx non e` multiplo di step_bbx !!!");
  if (delta_bby%step_bby)
    warn("warning: delta_bby non e` multiplo di step_bby !!!");
  if (bbx%2)
    warn("warning: bbx dovrebbe essere pari !!!");
  if (delta_bbx%2)
    warn("warning: delta_bbx dovrebbe essere pari !!!");
  if (step_bbx%2)
    warn("warning: step_bbx dovrebbe essere pari !!!");

  /* ocio! si potrebbe verificare */
  if (!image) return NULL;

  dG = 10;

  gray = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc gray");
  edge = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc edge");
  dens = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc dens");
  prod = Callocm(xidim, sizeof(struct local_bb), "Cannot malloc prod");

#ifdef COL
  dimx = delta_bbx/step_bbx+1;
  dimy = delta_bby/step_bby+1;
  sg = Mallocm(dimx*dimy*sizeof(double), "Cannot malloc sg");
  se = Mallocm(dimx*dimy*sizeof(double), "Cannot malloc se");
  de = Mallocm(dimx*dimy*sizeof(double), "Cannot malloc de");
  pr = Mallocm(dimx*dimy*sizeof(double), "Cannot malloc pr");
#endif

  /* ciclo per calcolo simmetrie */
#ifdef COL
  col = COL;
#else
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
#endif
    max_symm_gray = 0;
    row_max_gray = 0;
    h_max_gray = 0;
    w_max_gray = 0;
    max_symm_edge = 0;
    row_max_edge = 0;
    h_max_edge = 0;
    w_max_edge = 0;
    max_dens = 0;
    row_max_dens = 0;
    h_max_dens = 0;
    w_max_dens = 0;
    max_symm_tot = 0;
    row_max = 0;
    h_max = 0;
    w_max = 0;
    for (row=riga-delta_riga; row<=riga+delta_riga; row+=step_riga) {
      for (h=bby-delta_bby*(row<riga ? 1:0); h<=bby+delta_bby*(row>=riga ? 1:0); h+=step_bby) {
	for (w=bbx-delta_bbx*(row<riga ? 1:0); w<=bbx+delta_bbx*(row>=riga ? 1:0); w+=step_bbx) {  
	  bb_area = (double) (w-2)*(h-1);
	  cont_pixel_alike = 0;
	  cont_pixel_edge = 0;
	  cont_pixel_edge_symm = 0;
	  for (i=row-h+1; i<=row-1; i++) {
	    for (j=1; j<=(w-1)/2; j++) {
	      Gp = pick(image, xidim, i, col-j);
	      Gm = pick(image, xidim, i, col+j);
	      if (abs(Gp-Gm)<dG) cont_pixel_alike+=2;
	      a = pick(filtered_image, xidim, i, col-j);
	      b = pick(filtered_image, xidim, i, col+j);
	      if (a&128) cont_pixel_edge++;
	      if (b&128) cont_pixel_edge++;
	      if ((a&128)&&(b&128)) cont_pixel_edge_symm+=2;
	      }
	    }
	  
	  density = (cont_pixel_edge*cont_pixel_edge) / bb_area;
	  symm_gray = (cont_pixel_alike*cont_pixel_alike) / bb_area;
	  if (cont_pixel_edge == 0) 
	    symm_edge = 0;
    	  else 
	    symm_edge = (cont_pixel_edge_symm*cont_pixel_edge_symm) / ((double) cont_pixel_edge);
	  /*
	  symm_gray = cont_pixel_alike / bb_area; 
	  symm_edge = ((cont_pixel_edge_symm*cont_pixel_edge_symm)-(cont_pixel_edge-cont_pixel_edge_symm)*(cont_pixel_edge-cont_pixel_edge_symm)-(bb_area-cont_pixel_edge)*(bb_area-cont_pixel_edge)*0.01)/cont_pixel_edge;
	  if (symm_edge<0) symm_edge=0;
	  */
	  symm_tot = symm_gray * symm_edge * density;
	  
#ifdef COL
	  sg[(h-bby)/step_bby*dimx+(w-bbx)/step_bbx] = symm_gray;
	  se[(h-bby)/step_bby*dimx+(w-bbx)/step_bbx] = symm_edge;
	  de[(h-bby)/step_bby*dimx+(w-bbx)/step_bbx] = density;
	  pr[(h-bby)/step_bby*dimx+(w-bbx)/step_bbx] = symm_tot;
#endif
	  
	  if (symm_gray >= max_symm_gray) {
	    max_symm_gray = symm_gray;
	    row_max_gray = row;
	    h_max_gray = h;
	    w_max_gray = w;
	    }	    
	  if (symm_edge >= max_symm_edge) {
	    max_symm_edge = symm_edge;
	    row_max_edge = row;
	    h_max_edge = h;
	    w_max_edge = w;
	    }	    
	  if (density >= max_dens) {
	    max_dens = density;
	    row_max_dens = row;
	    h_max_dens = h;
	    w_max_dens = w;
	    }	    
	  if (symm_tot >= max_symm_tot) {
	    max_symm_tot = symm_tot;
	    row_max = row;
	    h_max = h;
	    w_max = w;
	    }	    
	  }
	}
      }
    gray[col].xo = col;
    gray[col].yo = row_max_gray;
    gray[col].h = h_max_gray;
    gray[col].w = w_max_gray;
    gray[col].symm = max_symm_gray;
    edge[col].xo = col;
    edge[col].yo = row_max_edge;
    edge[col].h = h_max_edge;
    edge[col].w = w_max_edge;
    edge[col].symm = max_symm_edge;
    dens[col].xo = col;
    dens[col].yo = row_max_dens;
    dens[col].h = h_max_dens;
    dens[col].w = w_max_dens;
    dens[col].symm = max_dens;
    prod[col].xo = col;
    prod[col].yo = row_max;
    prod[col].h = h_max;
    prod[col].w = w_max;
    prod[col].symm = max_symm_tot;
#ifndef COL
    }
#endif
    
  /* salvo istogramma prodotto su file */
  fp = Fopen("best_bb_per_col.txt", "w");
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) 
    fprintf(fp, "%hu %g\n", col, prod[col].symm);
  fclose(fp);

  /* costruisco mappe dei contibuti */
#ifdef COL
    max_sg = 0;
    max_se = 0;
    max_de = 0;
    max_pr = 0;
    for (i=0; i<dimy; i++) {
      for (j=0; j<dimx; j++) {
	if (sg[i*dimx+j] > max_sg)
	  max_sg = sg[i*dimx+j];
	if (se[i*dimx+j] > max_se)
	  max_se = se[i*dimx+j];
	if (de[i*dimx+j] > max_de)
	  max_de = de[i*dimx+j];
	if (pr[i*dimx+j] > max_pr)
	  max_pr = pr[i*dimx+j];
	}
      }
    isg = Mallocm(3*dimx*dimy*sizeof(unsigned char), "Cannot malloc isg");
    ise = Mallocm(3*dimx*dimy*sizeof(unsigned char), "Cannot malloc ise");
    ide = Mallocm(3*dimx*dimy*sizeof(unsigned char), "Cannot malloc ide");
    ipr = Mallocm(3*dimx*dimy*sizeof(unsigned char), "Cannot malloc ipr");
    for (i=0; i<dimy; i++) {
      for (j=0; j<dimx; j++) {
	if (sg[i*dimx+j] == max_sg) {
	  isg[3*(i*dimx+j)] = 255;
	  isg[3*(i*dimx+j)+1]=isg[3*(i*dimx+j)+2] = 0;
	  }
	else
	  isg[3*(i*dimx+j)]=isg[3*(i*dimx+j)+1]=isg[3*(i*dimx+j)+2] = (unsigned char) (max_sg ? sg[i*dimx+j]*255/max_sg : 0);
	if (se[i*dimx+j] == max_se) {
	  ise[3*(i*dimx+j)] = 255;
	  ise[3*(i*dimx+j)+1]=ise[3*(i*dimx+j)+2] = 0;
	  }
	else
	  ise[3*(i*dimx+j)]=ise[3*(i*dimx+j)+1]=ise[3*(i*dimx+j)+2] = (unsigned char) (max_se ? se[i*dimx+j]*255/max_se : 0);
	if (de[i*dimx+j] == max_de) {
	  ide[3*(i*dimx+j)] = 255;
	  ide[3*(i*dimx+j)+1]=ide[3*(i*dimx+j)+2] = 0;
	  }
	else
	  ide[3*(i*dimx+j)]=ide[3*(i*dimx+j)+1]=ide[3*(i*dimx+j)+2] = (unsigned char) (max_de ? de[i*dimx+j]*255/max_de : 0);
	if (pr[i*dimx+j] == max_pr) {
	  ipr[3*(i*dimx+j)] = 255;
	  ipr[3*(i*dimx+j)+1]=ipr[3*(i*dimx+j)+2] = 0;
	  }
	else
	  ipr[3*(i*dimx+j)]=ipr[3*(i*dimx+j)+1]=ipr[3*(i*dimx+j)+2] = (unsigned char) (max_pr ? pr[i*dimx+j]*255/max_pr : 0);
	}
      }
    write_pnm("symm_gray.pnm", isg, dimx, dimy);
    write_pnm("symm_edge.pnm", ise, dimx, dimy);
    write_pnm("density.pnm", ide, dimx, dimy);
    write_pnm("prodotto.pnm", ipr, dimx, dimy);
    free(sg);
    free(se);
    free(de);
    free(pr);
    free(isg);
    free(ise);
    free(ide);
    free(ipr);
#endif
      
  /* disegno gli istogrammi sull'immagine */
  img = Mallocm(3*xidim*yidim*sizeof(unsigned char),"allocazione img sym");
  for (i=0; i<xidim*yidim; i++)  
    img[i*3] = img[i*3+1] = img[i*3+2] = image[i];
  mg = 0;
  me  = 0;
  md = 0;
  mp = 0;
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
    if (gray[col].symm > mg)
      mg = gray[col].symm;
    if (edge[col].symm > me)
      me = edge[col].symm;
    if (dens[col].symm > md)
      md = dens[col].symm;
    if (prod[col].symm > mp)
      mp = prod[col].symm;
    }
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc) {
    rg = vett[0] = yidim-1 - (mg ? gray[col].symm/mg*(yidim/2) : 0);
    re = vett[1] = yidim-1 - (me ? edge[col].symm/me*(yidim/2) : 0);
    rd = vett[2] = yidim-1 - (md ? dens[col].symm/md*(yidim/2) : 0);
    rp = vett[3] = yidim-1 - (mp ? prod[col].symm/mp*(yidim/2) : 0);
    ordina(vett, 4);
    for (j=0; j<4; j++) {
      for (i=yidim-1; i>=vett[j]; i--) {
	if (vett[j] == rg) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	if (vett[j] == re) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	if (vett[j] == rd) {
	  img[3*(i*xidim+col)] = 255;
	  img[3*(i*xidim+col)+1] = 255;
	  img[3*(i*xidim+col)+2] = 0;
	  }
	if (vett[j] == rp) {
	  img[3*(i*xidim+col)] = 0;
	  img[3*(i*xidim+col)+1] = 0;
	  img[3*(i*xidim+col)+2] = 255;
	  } 
	}
      }
    rt = yidim-1 - (mp ? ts*(yidim/2)/mp : 0);
    if (rt<0) {
      img[3*col] = 0;
      img[3*col+1] = 255;
      img[3*col+2] = 255;
      }
    else if (rt>=yidim) {
      img[3*((yidim-1)*xidim+col)] = 0;
      img[3*((yidim-1)*xidim+col)+1] = 255;
      img[3*((yidim-1)*xidim+col)+2] = 255;
      }
    else {
      img[3*(rt*xidim+col)] = 0;
      img[3*(rt*xidim+col)+1] = 255;
      img[3*(rt*xidim+col)+2] = 255;
      }
    }

  /* cerco i picchi dell'istogramma prodotto */
  n = 0; 
  base = NULL;
  for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc)
    if (prod[col].symm < ts)
      prod[col].symm = 0;
  max_symm = 1;
  while (max_symm != 0) {
    max_symm = 0;
    col_max = 0;
    for (col=(bbx+delta_bbx)/2+BORD; col<=xidim-1-(bbx+delta_bbx)/2-BORD; col+=step_xc)
      if (prod[col].symm > max_symm) {
	col_max = col;
	max_symm = prod[col].symm;
	}
    if (max_symm > 0) {
      for (col=col_max-prod[col_max].w/2; col<=col_max+prod[col_max].w/2; col++)
	prod[col].symm = 0;
      p = alloc_bbox();
      p->xc = prod[col_max].xo;
      p->yc = prod[col_max].yo;
      p->xsize = prod[col_max].w;
      p->ysize = prod[col_max].h;
      p->next = base;
      base = p;
      n++;
      }
    }
  
  /* disegno i bb sull'img */
#ifdef PPDEBUG
  printf("\nSoglia simmetria: %g\n",ts);
  fprintf(stderr, "bb trovati dal peggiore al migliore:\n");
#endif
  /*
  if (n == 1)
    color = 255;
  else
  */
    color = 0;
  p = base;
  while (p != NULL) {
#ifdef PPDEBUG
    /* best bb di symm_gray */
    for (j=gray[p->xc].xo-gray[p->xc].w/2; j<=gray[p->xc].xo+gray[p->xc].w/2; j++) {
      img[3*((gray[p->xc].yo-gray[p->xc].h)*xidim+j)] = 255;
      img[3*((gray[p->xc].yo-gray[p->xc].h)*xidim+j)+1] = 0;
      img[3*((gray[p->xc].yo-gray[p->xc].h)*xidim+j)+2] = 0;
      img[3*((gray[p->xc].yo)*xidim+j)] = 255;
      img[3*((gray[p->xc].yo)*xidim+j)+1] = 0;
      img[3*((gray[p->xc].yo)*xidim+j)+2] = 0;
      }
    for (i=gray[p->xc].yo-gray[p->xc].h; i<=gray[p->xc].yo; i++) {
      img[3*(i*xidim+(gray[p->xc].xo-gray[p->xc].w/2))] = 255;
      img[3*(i*xidim+(gray[p->xc].xo-gray[p->xc].w/2))+1] = 0;
      img[3*(i*xidim+(gray[p->xc].xo-gray[p->xc].w/2))+2] = 0;
      img[3*(i*xidim+(gray[p->xc].xo+gray[p->xc].w/2))] = 255;
      img[3*(i*xidim+(gray[p->xc].xo+gray[p->xc].w/2))+1] = 0;
      img[3*(i*xidim+(gray[p->xc].xo+gray[p->xc].w/2))+2] = 0;
      }
    /* best bb di symm_edge */
    for (j=edge[p->xc].xo-edge[p->xc].w/2; j<=edge[p->xc].xo+edge[p->xc].w/2; j++) {
      img[3*((edge[p->xc].yo-edge[p->xc].h)*xidim+j)] = 0;
      img[3*((edge[p->xc].yo-edge[p->xc].h)*xidim+j)+1] = 255;
      img[3*((edge[p->xc].yo-edge[p->xc].h)*xidim+j)+2] = 0;
      img[3*((edge[p->xc].yo)*xidim+j)] = 0;
      img[3*((edge[p->xc].yo)*xidim+j)+1] = 255;
      img[3*((edge[p->xc].yo)*xidim+j)+2] = 0;
      }
    for (i=edge[p->xc].yo-edge[p->xc].h; i<=edge[p->xc].yo; i++) {
      img[3*(i*xidim+(edge[p->xc].xo-edge[p->xc].w/2))] = 0;
      img[3*(i*xidim+(edge[p->xc].xo-edge[p->xc].w/2))+1] = 255;
      img[3*(i*xidim+(edge[p->xc].xo-edge[p->xc].w/2))+2] = 0;
      img[3*(i*xidim+(edge[p->xc].xo+edge[p->xc].w/2))] = 0;
      img[3*(i*xidim+(edge[p->xc].xo+edge[p->xc].w/2))+1] = 255;
      img[3*(i*xidim+(edge[p->xc].xo+edge[p->xc].w/2))+2] = 0;
      }
    /* best bb di density */
    for (j=dens[p->xc].xo-dens[p->xc].w/2; j<=dens[p->xc].xo+dens[p->xc].w/2; j++) {
      img[3*((dens[p->xc].yo-dens[p->xc].h)*xidim+j)] = 255;
      img[3*((dens[p->xc].yo-dens[p->xc].h)*xidim+j)+1] = 255;
      img[3*((dens[p->xc].yo-dens[p->xc].h)*xidim+j)+2] = 0;
      img[3*((dens[p->xc].yo)*xidim+j)] = 255;
      img[3*((dens[p->xc].yo)*xidim+j)+1] = 255;
      img[3*((dens[p->xc].yo)*xidim+j)+2] = 0;
      }
    for (i=dens[p->xc].yo-dens[p->xc].h; i<=dens[p->xc].yo; i++) {
      img[3*(i*xidim+(dens[p->xc].xo-dens[p->xc].w/2))] = 255;
      img[3*(i*xidim+(dens[p->xc].xo-dens[p->xc].w/2))+1] = 255;
      img[3*(i*xidim+(dens[p->xc].xo-dens[p->xc].w/2))+2] = 0;
      img[3*(i*xidim+(dens[p->xc].xo+dens[p->xc].w/2))] = 255;
      img[3*(i*xidim+(dens[p->xc].xo+dens[p->xc].w/2))+1] = 255;
      img[3*(i*xidim+(dens[p->xc].xo+dens[p->xc].w/2))+2] = 0;
      }
#endif
    /* best bb di prod */
    for (j=p->xc-p->xsize/2; j<=p->xc+p->xsize/2; j++) {
      img[3*((p->yc-p->ysize)*xidim+j)]=img[3*((p->yc-p->ysize)*xidim+j)+1]=img[3*((p->yc-p->ysize)*xidim+j)+2] = color;
      img[3*((p->yc)*xidim+j)]=img[3*((p->yc)*xidim+j)+1]=img[3*((p->yc)*xidim+j)+2] = color;
      }
    for (i=p->yc-p->ysize; i<=p->yc; i++) {
      img[3*(i*xidim+(p->xc-p->xsize/2))]=img[3*(i*xidim+(p->xc-p->xsize/2))+1]=img[3*(i*xidim+(p->xc-p->xsize/2))+2] = color;
      img[3*(i*xidim+(p->xc+p->xsize/2))]=img[3*(i*xidim+(p->xc+p->xsize/2))+1]=img[3*(i*xidim+(p->xc+p->xsize/2))+2] = color;
      }
    if (n != 1)
      color += 256/(n-1)-1;
#ifdef PPDEBUG
    fprintf(stderr, "xc = %3hu  yc = %3hu  xsize = %3hu  ysize = %3hu\n", p->xc, p->yc, p->xsize, p->ysize);
#endif
    p = p->next;
    }

  write_pnm(nf, img, xidim, yidim);
  free(img);
  
  free(gray);
  free(edge);
  free(dens);
  free(prod);

  return base;
}


void ordina(int vettore[], int lung)
{
  int i, j, tmp;

  for(i=0; i<lung-1; i++)
    for(j=i+1; j<lung; j++)
      if (vettore[j] < vettore[i])
      {
        tmp = vettore[i];
        vettore[i] = vettore[j];
        vettore[j] = tmp;
      }
}

