#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"pgm.h"
#include"ll.h"
#include"alloca.h"
#include"die.h"

void read_pgm(unsigned char *image, int xdim, int ydim, char *filename)
{
  FILE *gzfp;
  int dimx, dimy, gray_t;
  register int i;
  char caratt, string[4]; /* beware buffer overruns !! */
  
  
  gzfp = Fopen(filename, "rb");

  string[0]=getc(gzfp);
  string[1]=getc(gzfp);
  string[2]=getc(gzfp);
  string[3]='\0';

  if (strcmp(string,"P5\n"))
    die("Unknown PGM header,", "bailing out...");
  caratt = getc(gzfp);
  while (caratt == '#')
    {
      for(i=0;caratt!='\n';++i)
	  caratt=getc(gzfp);    
      caratt = getc(gzfp);
    }
  ungetc(caratt,gzfp);
  if (fscanf(gzfp, "%d %d\n%d\n", &dimx, &dimy, &gray_t) != 3)
    die("Not in PGM format", "");
  if (dimx!=xdim || dimy!=ydim)  
    die("input size not correct", "");
  fread(image, sizeof(unsigned char), dimx*dimy, gzfp);
  fclose(gzfp);
}

void read_pgm_and_fit(unsigned char *dest, int xdim, int ydim, char *filename)
{
  FILE *gzfp;
  int dimx, dimy, gray_t;
  register int i;
  char caratt, string[4]; /* beware buffer overruns !! */
  unsigned char *image;

  
  gzfp = Fopen(filename, "rb");

  string[0]=getc(gzfp);
  string[1]=getc(gzfp);
  string[2]=getc(gzfp);
  string[3]='\0';

  if (strcmp(string,"P5\n"))
    die("Unknown PGM header,", "bailing out...");
  caratt = getc(gzfp);
  while (caratt == '#')
    {
      for(i=0;caratt!='\n';++i)
	  caratt=getc(gzfp);    
      caratt = getc(gzfp);
    }
  ungetc(caratt,gzfp);
  if (fscanf(gzfp, "%d %d\n%d\n", &dimx, &dimy, &gray_t) != 3)
    die("Not in PGM format", "");
  image=Mallocm(dimx*dimy*sizeof(unsigned char), "read_pgm_and_fit");
  fread(image, sizeof(unsigned char), dimx*dimy, gzfp);
  fclose(gzfp);

  /* e ora si infila in dest */
  ll_bilinear_interpolation(dest,xdim,ydim,image,dimx,dimy);
  /* ll_resample(dest,xdim,ydim,image,dimx,dimy);*/

  free(image);
}


void write_pgm(char *filename, unsigned char *img, int xdim, int ydim)
{
  FILE *fp;

  fp = Fopen(filename, "wb");
  fprintf(fp, "P5\n%d %d\n%d\n", xdim, ydim, WHITE);
  fwrite(img, sizeof(unsigned char), xdim*ydim, fp);
  fclose(fp);
}

void write_pnm(char *filename, unsigned char *img, int xdim, int ydim)
{
  FILE *fp;

  fp = Fopen(filename, "wb");
  fprintf(fp, "P6\n%d %d\n%d\n", xdim, ydim, WHITE);
  fwrite(img, sizeof(unsigned char), 3*xdim*ydim, fp);
  fclose(fp);
}

