#include<stdio.h>
#include<stdlib.h>
#include"alloca.h"
#include"pp.h"
#include"sym.h"
#include"ia.h"
#include"bbox.h"
#include"ll.h"
#include"output.h"
#include"pgm.h"

int main(int argc, char **argv){

  struct exe_timer *t;

  /* inizializzazione variabili globali
   * e lettura parametri */
  inizializza(argc,argv);

  /* binarizzazione immagini */
  t=alloc_timer();
  starttimer(t);
  preprocessa(left_inimage,left_thin,left_Nthin);
  if(is_stereo)
    preprocessa(right_inimage,right_thin,right_Nthin);
  stoptimer(t);
  stampatimer(t, "\nTempo esecuzione preprocessing");

  /* calcolo simmetrie*/
  resettimer(t);
  starttimer(t);
  left_bboxes=calcola_simmetrie(left_inimage, left_Nthin, "res_symm_l.pnm");
  if(is_stereo)
    right_bboxes=calcola_simmetrie(right_inimage, right_Nthin, "res_symm_r.pnm");
  stoptimer(t);
  stampatimer(t, "\nTempo esecuzione calcolo simmetrie");

  /* trova le catene corrispondenti ai box forniti */
  resettimer(t);
  starttimer(t);
  trova_chains(left_thin, left_bboxes);
  /* stampa_valori(left_bboxes); */
  immagine_controllo_catene("imcheck.pgm",left_bboxes); /*temporaneo per debug?!*/
  if(is_stereo){
    trova_chains(right_thin, right_bboxes);
    /* stampa_valori(right_bboxes); */
    immagine_controllo_catene("imcheck2.pgm",right_bboxes); /*temporaneo per debug?!*/
  }
  stoptimer(t);
  stampatimer(t, "\nTempo esecuzione individuazione catene");

  resettimer(t);
  starttimer(t);
  trova_pedoni(left_bboxes);
  if(is_stereo)
    trova_pedoni(right_bboxes);
  stoptimer(t);
  stampatimer(t, "\nTempo esecuzione individuazione pedoni");

  distruggitimer(t);

  crea_immagine_output(left_inimage,left_bboxes);
  /* scrivo risultati, per ora del preprocessing */
  write_pgm(outfile, left_inimage, xidim, yidim);

 return 0;
}

