#include<stdio.h>
#include<stdlib.h>
#include"die.h"
#include"alloca.h"
#include"pp.h"
#include"bbox.h"

#include"pgm.h" /*serve solo per immagine_controllo_catene() ovvero per la fase di debug*/

#define VERSIONE_INIZIO_INCLUSO


/* questa  funzione prende  in ingresso  l'elenco  di bbox */
/* e lo riempe con i dati delle chain trovate */
void trova_chains(unsigned char *image, struct bbox *p)
{
  short testa_xsize, testa_ysize, busto_xsize, busto_ysize, gambe_xsize, gambe_ysize;
  unsigned int origine_testa, origine_busto, origine_gambe, bordo_dx, bottom_right;
  unsigned char *imdummy;
  register int i;

  if(!p)return;

  imdummy = Mallocm(xidim*yidim*sizeof(unsigned char),"trova_chains");
  for(i=0;i<xidim*yidim;i++)
      imdummy[i] = SPENTO;
    
  while(p){

    /*inizializza rettangoli testa,busto,gambe - top_left,xsize,ysize*/
    p->tt = taglio_testa(p->ysize);
    p->tg = taglio_gambe(p->ysize);

    origine_testa = (p->yc - p->ysize)*xidim + p->xc - (p->xsize/2);  /*TO BE CHECKED: dipende da come e' definito il bbox*/
    origine_busto = origine_testa+(p->tt)*xidim;
    origine_gambe = origine_testa+(p->tg)*xidim;

    testa_xsize = busto_xsize = gambe_xsize = p->xsize;
    testa_ysize = p->tt;
    busto_ysize = p->tg - p->tt;
    gambe_ysize = p->ysize - p->tg;

    bordo_dx = (origine_testa%xidim)+ p->xsize;               /*ascissa del pixel appena fuori a dx*/  

    /*testa*/
    bottom_right = origine_testa + testa_xsize +(testa_ysize - 1)*xidim;     /*controllare il -1 nel bottom_right!!!*/
    for(i=origine_testa;i<bottom_right;i++){
      if(i%xidim == bordo_dx) i+= xidim - testa_xsize;
      imdummy[i] = (image[i] != SPENTO) ? 255 : SPENTO;
    }
    p->testa = crea_catena(imdummy, bottom_right, origine_testa);

    /*busto*/
    bottom_right = origine_busto + busto_xsize +(busto_ysize - 1)*xidim;     /*controllare il -1 nel bottom_right!!!*/
    for(i=origine_busto;i<bottom_right;i++){
      if(i%xidim == bordo_dx) i+= xidim - busto_xsize;
      imdummy[i] = (image[i] != SPENTO) ? 255 : SPENTO;
    }
    p->busto = crea_catena(imdummy, bottom_right, origine_busto);

    /*gambe*/
    bottom_right = origine_gambe + gambe_xsize +(gambe_ysize - 1)*xidim;     /*controllare il -1 nel bottom_right!!!*/
    for(i=origine_gambe;i<bottom_right;i++){
      if(i%xidim == bordo_dx) i+= xidim - gambe_xsize;
      imdummy[i] = (image[i] != SPENTO) ? 255 : SPENTO;
    }
    p->gambe = crea_catena(imdummy, bottom_right, origine_gambe);    

    p=p->next;
  }

  free(imdummy);
  return;
}


/*restituisce il parametro tt del bbox*/
short taglio_testa(short ysize)
{
  return (short) 0;
}


/*restituisce il parametro tg del bbox*/
short taglio_gambe(short ysize)
{
  return (short)ysize;
}


/*converte il pixel da numero d'ordine nel vect immagine in due coordinate cartesiane e memorizza*/
void memorizza_pixel(unsigned int x, struct bpixels *bpx)
{
  bpx->x = (short)(x%xidim);
  bpx->y = (short)(x/xidim);

  return; 
}


/*individua un nuovo punto acceso che appartiene ad una nuova catena - se ce n'e' ancora*/
unsigned int nuovo_inizio(unsigned char *image, unsigned int end, unsigned int x)
{
  while(x<=end){
    if(image[x] != SPENTO) return x;
    x++;
  }

  return -1;     /*non ci sono piu' punti accesi nel rettangolo*/
}


/*cerca il prossimo pixel della catena nelle adiacenze di quello passato come x*/
/*contiene il controllo che non si stia sforando i contorni del rettangolo*/

#ifdef CERCA_PROSSIMO_VECCHIA_VERSIONE
unsigned int cerca_prossimo(unsigned char *image, unsigned int x)
{ 

  /*pixel giu'*/
  if(image[x+xidim] != SPENTO) return x+xidim;

  /*pixel dx*/
  if(image[x+1] != SPENTO) return x+1;
  
  /*pixel su*/
  if(image[x-xidim] != SPENTO) return x-xidim;

  /*pixel sx*/
  if(image[x-1] != SPENTO) return x-1;

  /*pixel giu' sx*/
  if(image[x-1+xidim] != SPENTO) return x-1+xidim; 

  /*pixel giu' dx*/
  if(image[x+1+xidim] != SPENTO) return x+1+xidim;

  /*pixel su dx*/
  if(image[x+1-xidim] != SPENTO) return x+1-xidim;

  /*pixel su sx*/
  if(image[x-1-xidim] != SPENTO) return x-1-xidim;

  return -1;           /*non ci sono pixel accesi nell'intorno: la catena e' finita*/           
}
#endif

unsigned int cerca_prossimo(unsigned char *image, unsigned int x)
{ 
  register int count;
  unsigned int neo;
  int mem[8];

  for(count = 0; count < 8;count++)
    mem[count] = 0;
  count = 0;
  neo = -1;

  /*pixel su sx*/
  if(image[x-1-xidim] != SPENTO){
    neo = x-1-xidim;
    count++;
    mem[7]=1;
  }

  /*pixel su dx*/
  if(image[x+1-xidim] != SPENTO){
    neo = x+1-xidim;
    count++;
    mem[6]=1;
  }

  /*pixel giu' dx*/
  if(image[x+1+xidim] != SPENTO){
    neo = x+1+xidim;
    count++;
    mem[5]=1;
  }

  /*pixel giu' sx*/
  if(image[x-1+xidim] != SPENTO){
    neo = x-1+xidim;
    count++;
    mem[4]=1;
  }  

  /*pixel sx*/
  if(image[x-1] != SPENTO){
    neo = x-1;
    count++;
    mem[3]=1;
  }

  /*pixel su*/
  if(image[x-xidim] != SPENTO){
    neo = x-xidim;
    count++;
    mem[2]=1;
  }

  /*pixel dx*/
  if(image[x+1] != SPENTO){
    neo = x+1;
    count++;
    mem[1]=1;
  }

  /*pixel giu'*/
  if(image[x+xidim] != SPENTO){
    neo = x+xidim;
    count++;
    mem[0]=1;
  }

#ifdef VERSIONE_INIZIO_INCLUSO
  if(image[x]){              /*im[x] e' ancora acceso se e solo se e' un inizio catena - */
    image[x]=SPENTO;         /* - in tal caso accetto qualsiasi risultato e spengo l'inizio catena*/
    return neo;
  }
#endif

  if(count>2) return -1;  /*ci sono 3+ pixel accesi nell'intorno: la catena viene bloccata*/      
  if(count == 2){
    if(mem[0] && (mem[4]||mem[5])) return neo; /*la catena non viene spezzata se sono accesi 2 px adiacenti*/
    if(mem[1] && (mem[5]||mem[6])) return neo;
    if(mem[2] && (mem[6]||mem[7])) return neo;
    if(mem[3] && (mem[7]||mem[4])) return neo;
    return -1;                                 /*la catena termina se sono accesi 2 px NON adiacenti*/
  }
  return neo;                                  /*NB: neo = -1 per inizializzazione se non ci sono px accesi*/
}




/*costruisce una catena di pixels in modo ricorsivo*/
struct bpixels *crea_pixel(unsigned char *image, unsigned int precedente)
{
  unsigned int nuovo_px;
  struct bpixels *bpx;

  nuovo_px = cerca_prossimo(image,precedente);
  if(nuovo_px > xidim*yidim) return NULL;    /*controllo che non sia -1 in formato unsigned*/

  bpx = alloc_bpixels();
  memorizza_pixel(nuovo_px, bpx);
  image[nuovo_px] = SPENTO;
  
  bpx->next = crea_pixel(image,nuovo_px);
  return bpx;  
 
}


/*costruisce una catena a partire dal pixel "inizio_old" passato come argomento*/
struct bchain *crea_catena(unsigned char *image, unsigned int bottom_right, unsigned int inizio_old)
{
  unsigned int inizio_new;
  struct bchain *nuova_catena;

  inizio_new = nuovo_inizio(image, bottom_right, inizio_old);     
  if(inizio_new > xidim*yidim) return NULL;        /*non ci sono nuove catene nel rettangolo specificato*/

  nuova_catena = alloc_bchain(); 
  nuova_catena->pixels = alloc_bpixels();

  memorizza_pixel(inizio_new, nuova_catena->pixels); 

#ifndef VERSIONE_INIZIO_INCLUSO
  image[inizio_new] = SPENTO;     /*spegne il pixel di inizio della catena*/
#endif


  /*scansione: cerca una catena a partire dal pixel appena trovato in modo ricorsivo*/
  nuova_catena->pixels->next = crea_pixel(image,inizio_new);
  nuova_catena->next = crea_catena(image, bottom_right, inizio_new);

  return nuova_catena;
}










/* parte di stampa del contenuto variabili per debug */

void immagine_pixels(unsigned char *image, struct bpixels *p){
  for(;p;p=p->next){
    if(p->next == NULL) image[(p->y)*xidim+(p->x)] = 64; /*fine catena*/
    else image[(p->y)*xidim+(p->x)] = 255; /*in mezzo alla catena*/
  }
}

void immagine_catene(unsigned char *image, struct bchain *pbchains){
  
  for(;pbchains;pbchains=pbchains->next){
    image[(pbchains->pixels->y)*xidim+(pbchains->pixels->x)] = 128;  
    immagine_pixels(image, pbchains->pixels->next);
  }
}

void immagine_controllo_catene(char *filename, struct bbox *pbbox)
{
  unsigned char *imdummy;
  int i;

  imdummy = Mallocm(xidim*yidim*sizeof(unsigned char),"immagine_controllo_catene");
  for(i=0;i<xidim*yidim;i++)
      imdummy[i] = SPENTO;

  for(;pbbox;pbbox=pbbox->next){
    immagine_catene(imdummy,pbbox->gambe);
    immagine_catene(imdummy,pbbox->busto);
    immagine_catene(imdummy,pbbox->testa);
  }
  write_pgm(filename, imdummy, xidim, yidim);

  free(imdummy);
  return;
}

void stampa_catena_pixels(struct bpixels *p){
  for(;p;p=p->next){
    printf("   x=%d, y=%d\n",p->x,p->y);
  }
}

void stampa_catene(struct bchain *pbchains){
  int ii;
  
  for(ii=0;pbchains;pbchains=pbchains->next,++ii){
   printf("  catena n. %d\n:",ii);
   stampa_catena_pixels(pbchains->pixels);
  }
}

void stampa_tutti_valori(struct bbox *pbbox){

  for(;pbbox;pbbox=pbbox->next){
    printf("\nVALORI BOUNDING BOX\n");
    printf(" coordinate:      x=%d y=%d\n",pbbox->xc,pbbox->yc);
    printf(" dimensioni:      x=%d y=%d\n",pbbox->xsize,pbbox->ysize);
    printf(" testa:           %d\n",pbbox->tt);
    printf(" gambe:           %d\n",pbbox->tg);
    printf(" voto:            %d\n",pbbox->voto);
    printf(" validit:        %d\n",pbbox->valid);
    printf(" CATENE GAMBE\n");
    stampa_catene(pbbox->gambe);
    printf(" CATENE BUSTO\n");
    stampa_catene(pbbox->busto);
    printf(" CATENE TESTA\n");
    stampa_catene(pbbox->testa);
    printf("%d\n",(int)pbbox->testa);
  }
}

void stampa_valori(struct bbox *pbbox){
  struct bbox *p;
  
  if(!pbbox)return;
  p=pbbox->next;

  pbbox->next=NULL;
  stampa_tutti_valori(pbbox);
  pbbox->next=p;
}


/* allocazione ed inizializzazione */

struct bbox *alloc_bbox(void){
  struct bbox *p;
  p=Mallocm(sizeof(struct bbox),"alloc_bbox");
  p->valid=0;
  p->voto=0;
  p->gambe=p->testa=p->busto=NULL;
  p->next=NULL;

  return p;
}

struct bchain *alloc_bchain(void){
  struct bchain *p;
  p=Mallocm(sizeof(struct bchain),"alloc_bchain");
  p->pixels=NULL;
  p->next=NULL;

  return p;
}

struct bpixels *alloc_bpixels(void){
  struct bpixels *p;
  p=Mallocm(sizeof(struct bpixels),"alloc_bpixels");
  p->x=p->y=0;
  p->next=NULL;
  p->etichetta=0;
  p->voto=0;

  return p;
}




