#include<stdio.h>
#include<stdlib.h>
#include<sys/time.h>
#include"alloca.h"
#include"die.h"

/*****************************************************
   malloc e calloc integrate con i messaggi di errori
   chiunque necessita di allocare dinamicamente memoria puo'
   usarle in sostituzione delle malloc e calloc dato che
   richiedono gli stessi argomenti senza
   controllare il buon fine dell'operazione 
*****************************************************/


void *Calloc(size_t n, size_t a)
{
void *r;

if((r=calloc(n,a))==NULL)
 die("Error in Calloc",""); /*  die e' la funzione di gold che
                                da' in output il messaggio di errore e 
                                esce dal programma */
return r;
}

void *Malloc(size_t a)
{
void *r;

if((r=malloc(a))==NULL)
 die("Error in Calloc","");
return r;
}

/*****************************************************
   Mallocm e Callocm fanno la stessa cosa delle precedenti ma
   chiedono in ingresso anche il messaggio di errore (sicuramente piu' utile
   in fase di debug 
*****************************************************/

void *Mallocm(size_t a, const char *mess)
{
void *r;

if((r=malloc(a))==NULL)
 die((char*)mess,"");
return r;
}

void *Callocm(size_t n, size_t a, const char *mess)
{
void *r;

if((r=calloc(n,a))==NULL)
 die((char*)mess,""); 

return r;
}


FILE *Fopen(const char *path, const char *mode){
  FILE *fp;

  fp=fopen(path,mode);
  if(!fp)
    die("Fopen",path);
  return fp;
}


/* sezione timer */

struct exe_timer *alloc_timer(void){
  struct exe_timer *t;
  
  t=Mallocm(sizeof(struct exe_timer), "alloc_timer");
  resettimer(t);
  return t;
}

void resettimer(struct exe_timer *t){
  t->time=t->part=0;
}

void starttimer(struct exe_timer *t){
  struct timeval tt;

  gettimeofday(&tt,NULL);

  t->part=tt.tv_sec*1000000+tt.tv_usec;

}

void stoptimer(struct exe_timer *t)
{
  struct timeval tt;

  gettimeofday(&tt,NULL);

  t->time+=tt.tv_sec*1000000+tt.tv_usec-t->part;

}

void stampatimer(struct exe_timer *t, char *mess)
{
  fprintf(stdout,"%s: %ld usec\n",mess,t->time);
}

unsigned long gettimer(struct exe_timer *t){
  return t->time;
}

void distruggitimer(struct exe_timer *t){
  free(t);
}

