//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#ifndef WANDERER_H
#define WANDERER_H

#include "location.h"
#include "direction.h"
#include "status.h"

class Wanderer {
	public:
		// Constructor
		Wanderer(const Location &p = Location(0,0),
		const Direction &d = East);
		// Inspectors
		Direction GetDirection() const;
		Location GetLocation() const;
		// Facilitators for looking at surroundings
		void LookNorth(const Status &s);
		void LookEast(const Status &s);
		void LookSouth(const Status &s);
		void LookWest(const Status &s);
		// Direction mutator
		void SetDirection(const Direction &d);
		// Movement mutators
		void MoveNorth();
		void MoveEast();
		void MoveSouth();
		void MoveWest();
	private:
		// Data members
		Direction CurrDirection;
		Location CurrPos;
		bool OkNorth;
		bool OkEast;
		bool OkSouth;
		bool OkWest;
};


#endif
