//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************


#include "wanderer.h"

// Constructor 
Wanderer::Wanderer(const Location &p,
const Direction &d) {
	CurrPos = Location(p);
	SetDirection(d);
	OkNorth = OkEast = OkSouth = OkWest = false;
}
// Inspectors 
Direction Wanderer::GetDirection() const {
	return CurrDirection;
}
Location Wanderer::GetLocation() const {
	return CurrPos;
}
// Direction mutator
void Wanderer::SetDirection(const Direction &d) {
	CurrDirection = d;
}
// Looking facilitators 
void Wanderer::LookNorth(const Status &s) {
	OkNorth = (s != Obstacle) && (s != OutOfBounds);
}
void Wanderer::LookEast(const Status &s) {
	OkEast = (s != Obstacle) && (s != OutOfBounds);
}
void Wanderer::LookSouth(const Status &s) {
	OkSouth = (s != Obstacle) && (s != OutOfBounds);
}
void Wanderer::LookWest(const Status &s) {
	OkWest = (s != Obstacle) && (s != OutOfBounds);
}
// A movement mutator 
void Wanderer::MoveNorth() {
	if (OkNorth) {
		int r = CurrPos.GetRow();
		CurrPos.SetRow(r-1);
		SetDirection(North);
		OkNorth = OkEast = OkSouth = OkWest = false;
	}
}


