


#include "display.h"

#include <fstream>
using namespace std;


Display::Display(SimpleWindow &W, const Maze &M, float size) : DisplayWindow(W) {
	int nr = M.GetNumberRows();
	int nc = M.GetNumberColumns();
	View.resize(nr, vector<DisplaySymbol>(nc, UnseenSymbol));
	for (int r = 0; r < nr; ++r) {
		for (int c = 0; c < nc; ++c) {
			Location p(r,c);
			switch (M.GetStatus(p)) {
			case Start:
				View[r][c] = StartSymbol; 
				break;
			case Finish:
				View[r][c] = FinishSymbol; 
				break;
			case Obstacle:
				View[r][c] = ObstacleSymbol; 
				break;
			case Free:
				View[r][c] = UnseenSymbol; 
				break;
			}
		}
	}
	SetScale(size);
}

void Display::SetErrant(const Location &p) {
	int r = p.GetRow();
	int c = p.GetColumn();
	View[r][c] = ErrantSymbol;
}

void Display::SetStepped(const Location &p) {
	int r = p.GetRow();
	int c = p.GetColumn();
	View[r][c] = StepSymbol;
}

void Display::DisplayAll() {
	for (int r = 0; r < View.size(); ++r) {
		for (int c = 0; c < View[r].size(); ++c) {
			Location p(r,c);
			DisplayLocation(p);
		}
	}
}

void Display::DisplayLocation(const Location &p) {
	int r = p.GetRow();
	int c = p.GetColumn();
	switch (View[r][c]) {
	case ObstacleSymbol:
		DisplayObstacle(p);
		break;
	case StepSymbol:
		DisplayStep(p);
		break;
	case UnseenSymbol:
		DisplayUnseen(p);
		break;
	case ErrantSymbol:
		DisplayErrant(p);
		break;
	case StartSymbol:
		DisplayStart(p);
		break;
	case FinishSymbol:
		DisplayFinish(p);
		break;
	}
}

float Display::GetScale() const {
	return LocationSide;
}

void Display::SetScale(float s) {
	LocationSide = s;
}

SimpleWindow& Display::GetDisplayWindow() {
	return DisplayWindow;
}

void Display::DisplayStart(const Location &p) {
	DisplayUnseen(p);
	float unit = GetScale(); 
	float side = unit/6;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R(GetDisplayWindow(), x, y, Blue, side, side);
	R.Draw();
}

void Display::DisplayFinish(const Location &p) {
	DisplayUnseen(p);
	float unit = GetScale(); 
	float side = unit/6;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R(GetDisplayWindow(), x, y, Blue, side, side);
	R.Draw();

}

void Display::DisplayErrant(const Location &p) {
	float unit = GetScale(); 
	float side = unit/2;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R1(GetDisplayWindow(), x, y, Magenta, side, side);
	RectangleShape R2(GetDisplayWindow(), x, y, White, 3*side/4, 3*side/4);
	R1.Draw();
	R2.Draw();
}

void Display::DisplayStep(const Location &p) {
	float unit = GetScale(); 
	float side = unit/2;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R(GetDisplayWindow(), x, y, Magenta, side, side);
	R.Draw();

}

void Display::DisplayUnseen(const Location &p) {
	float unit = GetScale();
	float side = unit;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R(GetDisplayWindow(), x, y, White, unit, unit);
	R.Draw();
}

void Display::DisplayObstacle(const Location &p) {
	float unit = GetScale(); 
	float side = unit;
	float x = p.GetColumn() * unit + unit/2;
	float y = p.GetRow() * unit + unit/2;
	RectangleShape R(GetDisplayWindow(), x, y, Blue, unit, unit);
	R.Draw();
}

