//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.3 $
// $Name: E2 $
//
//**************************************************************************

#ifndef PATH_H
#define PATH_H

#include <vector>
using namespace std;

#include "location.h"

class Path {
	public:
		// Constructor
		Path(const Location &p = Location(0,0));
		// Inspectors
		bool Contains(const Location &p) const;
		Location at(int i) const;
		int size() const;
		// Mutators
		void Append(const Location &p);
		void DeleteLocation(int i);
		void Set(int i, const Location &p);
		// Iterators
		vector<Location>::iterator begin();
		vector<Location>::iterator end();
	private:
		vector<Location> CurrSeq;
};

bool operator == (const Location &a, const Location &b);
bool operator < (const Location &a, const Location &b);

#endif
