//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#ifndef MAZE_H
#define MAZE_H

#include <iostream>
#include <string>
#include <vector>
using namespace std;

#include "status.h"
#include "location.h"

class Maze {
	public:
		// Constructor: extract maze layout from file
		Maze(istream &sin = cin);
		// Constructor: random maze with dimensions r by c
		Maze(int r = 20, int c = 30);
		// Inspectors
		Status GetStatus(const Location &p) const;
		Location GetStart() const;
		Location GetFinish() const;
		int GetNumberRows() const;
		int GetNumberColumns() const;
	protected:
		// Mutator
		void SetStatus(const Location &p,
		const Status &s);
	private:
		// Data members
 		vector< vector < Status > > Grid;
		Location StartPos;
		Location FinishPos;
};


#endif
