//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#include <assert.h>

#include "maze.h"

// Constructor: extract maze layout from file
Maze::Maze(istream &sin) {
	// extract dimensions
	int NumberRows;
	int NumberColumns;
	sin >> NumberRows >> NumberColumns;
	// set all grid positions free
	Grid.resize(
	NumberRows, vector<Status>(NumberColumns, Free));
	// extract and set ending points
	sin >> StartPos >> FinishPos;
	SetStatus(StartPos, Start);
	SetStatus(FinishPos, Finish);
	// extract and set obstacles
	Location p;
	while (sin >> p) {
		SetStatus(p, Obstacle);
	}
}
// Inspectors
Location Maze::GetStart() const {
	return StartPos;
}
Location Maze::GetFinish() const {
	return FinishPos;
}
int Maze::GetNumberRows() const {
	return Grid.size();
}
int Maze::GetNumberColumns() const {
	return Grid[0].size();
}
Status Maze::GetStatus(const Location &p) const {
	int r = p.GetRow();
	int c = p.GetColumn();
	if ((r < 0) || (r >= GetNumberRows())) {
		return OutOfBounds;
	}
	else if ((c < 0) || (c >= GetNumberColumns())) {
		return OutOfBounds;
	}
	else {
		return Grid[r][c];
	}
}
// Mutator
void Maze::SetStatus(const Location &p, const Status
&s) {
	int r = p.GetRow();
	int c = p.GetColumn();
	assert((r >= 0) && (r < GetNumberRows()));
	assert((c >= 0) && (c < GetNumberColumns()));
	Grid[r][c] = s;
}


