//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#ifndef LOCATION_H
#define LOCATION_H

#include <iostream>
#include <string>
using namespace std;

class Location {
	public:
		// Constructor
		Location(int r = 0, int c = 0);
		// Inspectors
		int GetRow() const;
		int GetColumn() const;
		// Mutators
		void SetLocation(const Location &p);
		void SetLocation(int r, int c);
		void SetRow(int r);
		void SetColumn(int c);
	private:
		// Data members
		int Row;
		int Column;
};

bool operator==(const Location &p, const Location &q);
bool operator!=(const Location &p, const Location &q);
istream& operator>>(istream &sin, Location &p);

#endif
