//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#include "location.h"
// Constructor 
Location::Location(int r, int c) {
	SetLocation(r,c);
}
// Inspectors 
int Location::GetRow() const {
	return Row;
}
int Location::GetColumn() const {
	return Column;
}
// Mutators 
void Location::SetLocation(const Location &p) {
	SetRow(p.GetRow());
	SetColumn(p.GetColumn());
}
void Location::SetLocation(int r, int c) {
	SetRow(r);
	SetColumn(c);
}
void Location::SetRow(int r) {
	Row = r;
}
void Location::SetColumn(int c) {
	Column = c;
}
// ==: Location auxiliary operator 
bool operator==(const Location &p, const Location &q) {
	return (p.GetRow() == q.GetRow())
	&& (p.GetColumn() == q.GetColumn());
}
// !=: Location auxiliary operator 
bool operator!=(const Location &p, const Location &q) {
	return ! (p == q);
}
// >>: Location auxiliary operator 
istream& operator>>(istream &sin, Location &p) {
	int r;
	int c;
	sin >> r >> c;
	p = Location(r, c);
	return sin;
}


