//**************************************************************************
//
// Copyright (c) 1997-1999.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/1/98
// $Revision: 1.1 $
// $Name: E2 $
//
//**************************************************************************

#ifndef DISPLAY_H
#define DISPLAY_H

#include "rect.h"

#include "maze.h"

enum DisplaySymbol {
	StartSymbol, FinishSymbol, ErrantSymbol,
	StepSymbol, UnseenSymbol, ObstacleSymbol};

class Display {
	public:
		Display(SimpleWindow &W, const Maze &M,
		float side = 0.75);
		void SetErrant(const Location &p);
		void SetStepped(const Location &p);
		void DisplayAll();
		SimpleWindow& GetDisplayWindow();
		float GetScale() const;
		void DisplayLocation(const Location &p);
	protected:
		void DisplayStart(const Location &p);
		void DisplayFinish(const Location &p);
		void DisplayErrant(const Location &p);
		void DisplayStep(const Location &p);
		void DisplayUnseen(const Location &p);
		void DisplayObstacle(const Location &p);
		void SetScale(float s);
	private:
		vector< vector<DisplaySymbol> > View;
		SimpleWindow &DisplayWindow;
		float LocationSide;
};


#endif
