// Classi per la comunita' universitaria e classi derivate
// file university.h
//
// Usa il polimorfismo ( e le funzioni virtuali)
//

#include <stdio.h>
#include <string.h>
#include "iostream.h"

class universitario
{
friend class list;

protected:
  char cognome[15];
  char nome[15];
  int anno_nascita;
  static universitario* ptr; // dichiarazione NON definizione  !!!!!!
                             // bisogna definirlo esternamente !!!!!!
  universitario* next;

public:
  universitario(char* c,char* n,int a)
    {
     strcpy(cognome,c);
     strcpy(nome,n);
     anno_nascita=a;
     next=0;
    }
  universitario()
    {
     cognome[0]='\0';
     nome[0]='\0'; 
     anno_nascita=0;
     next=0;
    }
  void set_cognome(char* cogn) {strcpy(cognome,cogn);}
  void set_nome(char* nom) {strcpy(nome,nom);}
  void set_anno_nascita(int a) {anno_nascita=a;}

  virtual void print()
    {
     cout << endl << cognome << " " << nome << endl;
     cout << " anno di nascita: " << anno_nascita << endl;
     }

  virtual void insert(){}
};


class studente :public universitario
{
  friend class list;

private: 
  char corso_laurea[15];
  int anno_iscrizione;
  int esami_sostenuti;

public:
  studente(char* n,char* c,int a,char* cl,int ai,int es):universitario(n,c,a)   
    {
     strcpy(corso_laurea,cl);
     anno_iscrizione=ai;
     esami_sostenuti=es;
    }
  studente():universitario()
    {
     corso_laurea[0]='\0';
     anno_iscrizione=0;
     esami_sostenuti=0;
    }

  void set_corso_laurea(char* cl){strcpy(corso_laurea,cl);}
  void set_anno_iscrizione(int ai){anno_iscrizione=ai;}
  void set_esami_sostenuti(int es){esami_sostenuti=es;}

  void print()
    {
     universitario::print();
     cout << "Corso di Laurea: " << corso_laurea << endl
          << "anno iscrizione: " << anno_iscrizione 
          << " numero esami sostenuti: " << esami_sostenuti << endl;  
     }
  void insert()
    {
     ptr = new studente(cognome,nome,anno_nascita,corso_laurea,
                        anno_iscrizione,esami_sostenuti);
    }  
}; 

class dipendente : public universitario
{
friend class list;
protected:
 int anzianita_servizio;
public:
  dipendente(char* n,char* c,int a,int an_s):universitario(n,c,a)   
    {anzianita_servizio = an_s;}
  dipendente() : universitario()   
    {anzianita_servizio = 0;}
  
  void set_anzianita_servizio(int as){anzianita_servizio = as;}
 
  void print()
    {
     universitario::print();
     cout << "anzianita' di servizio: " << anzianita_servizio  << endl;
      
     }
  void insert()
    {ptr = new dipendente(cognome,nome,anno_nascita,anzianita_servizio);}
}; 


class professore :public dipendente
{
  friend class list;

private: 
  char nome_corso[15];
  char facolta[15];
  
public:
  professore(char* n,char* c,int a,int as,char* nc,char* f):dipendente(n,c,a,as)
    {
     strcpy(nome_corso,nc); 
     strcpy(facolta,f);
    }
  professore():dipendente()
    {
     nome_corso[0]='\0'; 
     facolta[0]='\0';
    }

  void set_nome_corso(char* nc){strcpy(nome_corso,nc);}
  void set_facolta(char* f){strcpy(facolta,f);}

  void print()
    {
     dipendente::print();
     cout << "Corso: " << nome_corso << " Facolta': " << facolta << endl ; 
    }

  void insert()
    {
     ptr = new professore(cognome,nome,anno_nascita,
               anzianita_servizio,nome_corso,facolta);
    }
}; 


class amministrativo :public dipendente
{
  friend class list;

private: 
  char qualifica[15];
  char ufficio[15];
  
public:
  amministrativo(char* n,char* c,int a,int as,char* q,char* u):
        dipendente(n,c,a,as)
    {
     strcpy(qualifica,q); 
     strcpy(ufficio,u);
    }
  amministrativo():dipendente()
    {
     qualifica[0]='\0'; 
     ufficio[0]='\0';
    }

  void set_qualifica(char* q){strcpy(qualifica,q);}
  void set_ufficio(char* u){strcpy(ufficio,u);}

  void print()
    {
     dipendente::print();
     cout << "Qualifica: " << qualifica << " Ufficio: " << ufficio << endl ; 
    }

  void insert()
    {
     ptr = new amministrativo(cognome,nome,anno_nascita,
               anzianita_servizio,qualifica,ufficio);
    }
}; 


class list
{
private:
  universitario* root;
public:
  list(){root=0;}
  void insert_person(universitario* n);
  void remove(char* cognome);
  void print_list();
};
  
 

