// File shapes_virt.C
// semplice esempio di polimorfismo e uso di "virtual"
// qua draw e' una funzione virtuale
// il legame e' di tipo DINAMICO

#include "iostream.h"

class shape
{
public:
  virtual void draw(){cout << "metodo -> shape::draw" << endl;}
};

class circle : public shape
{
public:
  void draw(){cout << "metodo -> circle::draw" << endl;}
};

class square : public shape
{
public:
  void draw(){cout << "metodo -> square::draw" << endl;}
};

class triangle : public shape 
{
public:
  void draw(){cout << "metodo -> triangle::draw" << endl;}
};

/* list contiene puntatori a oggetti di tipo shape
   ma il vettore viene inizializzato con puntatori
   a circle, square e triangle
   Questo e' possibile perche' circle etc. sono
   sottoclassi di shape */

main()
{ shape * list[3] = { new circle, new square, new triangle};
  for (int i=0; i< 3; i++)
    list[i]->draw();
}


/* la funzione draw e' definita come VIRTUAL
   in questo caso il legame con la funzione draw e'
   definito dinamicamente (al tempo dell'esecuzione)
   in base al tipo di puntatore (non determinabile a
   priori dal compilatore) viene scelta la funzione da eseguire
*/   

/*
verdi> g++ shapes_virt.C
verdi> a.out
metodo -> circle::draw
metodo -> square::draw
metodo -> triangle::draw
verdi> 
*/
