// File shapes_no_virt.C
// semplice esempio di polimorfismo e uso di "virtual"
// qua draw NON e' una funzione virtuale
// il legame e' di tipo STATICO

#include "iostream.h"

class shape
{
public:
  void draw(){cout << "metodo -> shape::draw" << endl;}
};

class circle : public shape
{
public:
  void draw(){cout << "metodo -> circle::draw" << endl;}
};

class square : public shape
{
public:
  void draw(){cout << "metodo -> square::draw" << endl;}
};

class triangle : public shape 
{
public:
  void draw(){cout << "metodo -> triangle::draw" << endl;}
};

/* list contiene puntatori a oggetti di tipo shape
   ma il vettore viene inizializzato con puntatori
   a circle, square e triangle
   Questo e' possibile perche' circle etc. sono
   sottoclassi di shape */

main()
{ shape * list[3] = { new circle, new square, new triangle};
  for (int i=0; i< 3; i++)
    list[i]->draw();
}


/* la funzione draw e' definita normalmente
   poiche list e' di tipo shape viene richiamato il metodo
   shape::draw
   il legame e' di tipo STATICO cioe' definito al tempo della
   COMPILAZIONE
*/   

/*

shapeverdi> g++ shapes_no_virt.C
verdi> a.out
metodo -> shape::draw
metodo -> shape::draw
metodo -> shape::draw
verdi> 
*/
