// file genList.h
// This code defines a class for a single linked list of generic elements

#include <stdio.h>
class node
{
 friend class list;
 private:
   node *next;
   char* contents; // contents dinamically allocated
};

class list
{
 private:
   node* head; // Head of list   
   node* back; // Back of list for append 
   int size;   // number of bytes for contents
 protected:
   void stampa_size(){printf("\nsize = %d\n",size);} 
 public:
   list(int s) { head=0; back=0; size=s; }
   int empty(){return (head==0);} // Test for an empty list 
   void insert(char* a) ; // Add to the front of the list
   void append(char* a) ; // Add to the back of the list
   char* get() ;          // Remove the head of the list  
   void clear();          // Remove all the nodes of the list     
   ~list(){clear();}
};
