// Usa la classe "list" per derivare
// stack e code
// file genList2tst.C

#include "iostream.h"
#include "genList.h"

// list non ha qualificatori.
// in questo caso i metodi di list sono utilizzabili
// nell'implementazione di int_stack 
// ma  non esternamente come metodi applicabili agli oggetti di int_stack
// empty deve essere ridefinito anche se e' identico a list::empty

class int_stack : list
{
 public:
  void push(int a){list::insert((char *) &a);}
  int pop(){return *((int *) list::get());}
  int empty(){return list::empty();}
  int_stack() : list(sizeof(int)){}
};

class char_queue : list
{
public:
  void put(char a){list::append((char *) &a);}
// get ha due significati diversi per char_queue e per list  
  char get(){return *(list::get());}
  int empty(){return list::empty();}
  char_queue() : list(sizeof(char)){}
};

		   

main()
{
  int_stack my_stack;
  char_queue my_queue;
  my_stack.push(1);
  my_stack.push(2);
  my_stack.push(3);
  cout << "***  stack ***" << endl;
  while (! my_stack.empty())
    {cout << my_stack.pop()<< endl;}
  cout << "*** queue ***" << endl;
  my_queue.put('A'); 
  my_queue.put('B'); 
  my_queue.put('C'); 
  while (! my_queue.empty())
    {cout << my_queue.get() << endl;} 
}

/*
verdi> g++ genList.C genList2tst.C 
verdi> a.out
***  stack ***
3
2
1
*** queue ***
A
B
C
verdi>
*/  
