// file fiendly.C --- Dimostrazione di funzioni di tipo friendly
// La funzione synchronize() ha argomenti sia della classe
// watch che della classe microwave_oven. La prima volta
// che syncronize() e' dichiarata come friend in watch, il compilatore
// non sa che microwave_oven esiste a meno che non ne si
// dichiari prima il nome:

class microwave_oven;

class watch
{
  int time;  // una misura di tempo;
  int alarm; // quando l'allarme scatta
public:
  // il costruttore definisce lo stato iniziale
  watch(){time=0;alarm=2000;};
  void tick() {time++;}  // transizione molto semplice
  // dichiara la funzione amica
  // N.B. i parametri sono passati per riferimento
  friend void synchronize(watch&, microwave_oven&);
};

class microwave_oven
{
  int time;
  int start_time;
  int stop_time;
public:
  microwave_oven()
  {
    time=0;
    start_time=20;
    stop_time=100;
  }
  void tick() {time++;}
  // synchronize() viene dichiarata amica anche della classe microwave_oven
  friend void synchronize(watch&, microwave_oven&);
};

void synchronize(watch& objA, microwave_oven& objB)
{objA.time = objB.time = 15;}   // definisce uno stato comune
  
void main()
{watch che_ora;
 microwave_oven un_forno;
 che_ora.tick();
 un_forno.tick();
 synchronize(che_ora,un_forno);
}
  
