// file complex.C
// definizione del tipo complessi 
// con overloading di operatori

#include "iostream.h"

class complex {
 float re,im;
public:

// gli argomenti del costruttore sono opzionali 
// se specificati permettono di dare un valore al complex
// all'atto della sua dichiarazione
// in alternativa si puo' usare assegna
 complex(float r=0.0,float i=0.0){re=r;im=i;};

// assegna il valore ad un numero complesso dando parte.re e parte.im
 complex assegna(float reale, float immaginaria)
    {re=reale;
     im=immaginaria;
     return (*this);
    }

//selettori
 float parte_re(void){return re;}
 float parte_im(void){return im;}

// operatore + definito esternamente (come friend)
// nota la differenza con - definito inline
// se e' esterno servono 2 argomenti
// se e' interno 1 solo (il primo arg e'l'oggetto a cui il messagg. e'diretto) 
 friend complex operator+(complex num1, complex num2);

// += si puo' usare la forma c1 += c2
//   oltre ad aggiornare c1 ritorna il risutato finale (come l'assegnamento) 
 complex operator+=(complex num1)
  {re=re+num1.re;
   im=im+num1.im;
   return (*this);}

// operatore - definito inline (confronta con  +)
 complex operator-(complex num1)
 {
  return complex(re-num1.re,im-num1.im);
 }

// assegnamento c1=<complex><exp>
 complex operator=(complex num)
   {re=num.re;
    im=num.im;
    return (*this);
    }

// predicato ==

int operator==(complex num)
 {return ((re==num.re)&&(im==num.im));}

// stampa il numero complesso
 void stampa()
   {cout << re ;
    (im < 0.0) ? cout << " -i " << -im : cout << " i " << im;
   }    
// metodo alternativo di stampa con l'overload di <<
// notare ostream& come tipo della funzione !!!!!!!!!!!!!

 friend ostream& operator << (ostream & s, complex comp);
};  // Fine definizione della classe

complex operator+(complex num1, complex num2)
 {
  return complex(num1.re+num2.re,num1.im+num2.im);
 }

ostream&  operator << (ostream & s, complex comp)
 { return((comp.im >= 0) ? (s << comp.re <<"+i"<< comp.im) : (s << comp.re <<"-i"<< -comp.im)) ;}



// file complex.C (continua)

void main(void)
{complex nc1,nc2,nc3;
// si usa assegna
 nc1.assegna(5.0,-7.0);
 nc2.assegna(4.0,4.0);
// assegnamento
 nc3=nc1+nc2;
 nc3.stampa();
 cout << endl << nc3 <<endl;
// il costruttore viene usato per dare un valore iniziale
 complex nca(7,8);
 complex ncb(6,9); 
 cout << (nca-ncb) <<endl;
// seconda forma di assegnamento 
 nca += ncb;
 cout << nca << endl;
// predicato == con espressione complessa 
 if (nca-(nc1+nc2-nc3)+complex(-13,-17)==complex(0,0))
   cout << "espressione = zero" << endl; 
 }  

/*  ESEMPIO DI ESECUZIONE

verdi> g++ complex.C
verdi> a.out
9 -i 3
9-i3
1-i1
13+i17
espressione = zero
verdi>

*/





