// Classi per la comunita' universitaria e classi derivate
// file pers_univ.C
//
// Usa il polimorfismo ( e le funzioni virtuali)
//

#include <stdio.h>
#include <string.h>
#include "iostream.h"
#include "ListeCaseStudy.C"

class universitario
{
  
  // char xxxxx[15];    // perche c'e qualcosa che non va
  char cognome[15];
  char nome[15];
  int anno_nascita;
public:
  universitario(char* c,char* n,int a)
    {
     strcpy(cognome,c);
     strcpy(nome,n);
     anno_nascita=a;
    }
  universitario()
    {
     cognome[0]='\0';
     nome[0]='\0'; 
     anno_nascita=0;
    }
  universitario(const universitario & val) {*this=val;}  


  virtual universitario *duplicate() const {
     return new universitario((*this));
  }

virtual universitario &operator =(const universitario &val){
     strcpy(cognome,val.cognome);
     strcpy(nome,val.nome);
     anno_nascita=val.anno_nascita;
     return *this;
  }

  const int operator ==(const universitario &val) const {return 1;}
  const int operator !=(const universitario &val) const 
    {return !(*this==val);
    }
   

  void set_cognome(char* cogn) {strcpy(cognome,cogn);}
  void set_nome(char* nom) {strcpy(nome,nom);}
  void set_anno_nascita(int a) {anno_nascita=a;}

  virtual void print()
    {
     cout << endl << cognome << " " << nome << endl;
     cout << " anno di nascita: " << anno_nascita << endl;
     }

  virtual void insert(){}
};


class studente :public universitario
{

private: 
  char corso_laurea[15];
  int anno_iscrizione;
  int esami_sostenuti;

public:
  studente(char* n,char* c,int a,char* cl,int ai,int es):universitario(n,c,a)   
    {
     strcpy(corso_laurea,cl);
     anno_iscrizione=ai;
     esami_sostenuti=es;
    }
  studente():universitario()
    {
     corso_laurea[0]='\0';
     anno_iscrizione=0;
     esami_sostenuti=0;
    }
 
 studente (const studente & val) {*this=val;}
  
virtual studente *duplicate() const {
     return new studente((*this));
  }

 studente &operator =(const studente &val){
   universitario::operator =(val); 
     strcpy(corso_laurea,val.corso_laurea);
     anno_iscrizione=val.anno_iscrizione;
     esami_sostenuti=val.esami_sostenuti;
     return *this;
 }

  void set_corso_laurea(char* cl){strcpy(corso_laurea,cl);}
  void set_anno_iscrizione(int ai){anno_iscrizione=ai;}
  void set_esami_sostenuti(int es){esami_sostenuti=es;}

  void print()
    {
     universitario::print();
     cout << "Corso di Laurea: " << corso_laurea << endl
          << "anno iscrizione: " << anno_iscrizione 
          << " numero esami sostenuti: " << esami_sostenuti << endl;  
    }
};


class dipendente : public universitario
{


 int anzianita_servizio;
public:
  dipendente(char* n,char* c,int a,int an_s):universitario(n,c,a)   
    {anzianita_servizio = an_s;}
  dipendente() : universitario()   
    {anzianita_servizio = 0;}

  dipendente (const dipendente & val) {*this=val;}
  virtual dipendente  *duplicate()const {
     return new dipendente((*this));
  }


  dipendente &operator =(const dipendente &val){
   universitario::operator =(val); 
     anzianita_servizio=val.anzianita_servizio;
     return *this;
 }
 
  
  void set_anzianita_servizio(int as){anzianita_servizio = as;}
 
  void print()
    {
     universitario::print();
     cout << "anzianita' di servizio: " << anzianita_servizio  << endl;
      
     }
}; 


class professore :public dipendente
{
 
  char nome_corso[15];
  char facolta[15];
  
public:
  professore(char* n,char* c,int a,int as,char* nc,char* f):dipendente(n,c,a,as)
    {
     strcpy(nome_corso,nc); 
     strcpy(facolta,f);
    }
  professore():dipendente()
    {
     nome_corso[0]='\0'; 
     facolta[0]='\0';
    }

  void set_nome_corso(char* nc){strcpy(nome_corso,nc);}
  void set_facolta(char* f){strcpy(facolta,f);}

  void print()
    {
     dipendente::print();
     cout << "Corso: " << nome_corso << " Facolta': " << facolta << endl ; 
    }
}; 


class amministrativo :public dipendente
{
  char qualifica[15];
  char ufficio[15];
  
public:
  amministrativo(char* n,char* c,int a,int as,char* q,char* u):
        dipendente(n,c,a,as)
    {
     strcpy(qualifica,q); 
     strcpy(ufficio,u);
    }
  amministrativo():dipendente()
    {
     qualifica[0]='\0'; 
     ufficio[0]='\0';
    }

  void set_qualifica(char* q){strcpy(qualifica,q);}
  void set_ufficio(char* u){strcpy(ufficio,u);}

  void print()
    {
     dipendente::print();
     cout << "Qualifica: " << qualifica << " Ufficio: " << ufficio << endl ; 
    }

}; 






class Elemento {
universitario *ptr;
public: 
   Elemento(const universitario &val){
    ptr = val.duplicate();
    cout << "Costruttore Elemento ptr studente "<< ptr << endl;
    ptr->print(); 
  }  
  
  /*
  Elemento(const studente &val){
    ptr = new studente(val);
    cout << "Costruttore Elemento ptr studente "<< ptr << endl;
    ptr->print(); 
  } 
 Elemento(const dipendente &val){
  ptr = new dipendente(val);
  cout << "Costruttore Elemento ptr dipendente "<< ptr << endl;
    ptr -> print(); 
  } 
  */ 
 
 Elemento(const Elemento &val) {                     
     ptr=val.ptr->duplicate();
}
  
  ~Elemento(){ delete ptr;
  cout << "distruttore di Elemento ptr= " << ptr <<endl;}
  Elemento &operator=(const Elemento &val) {ptr = val.ptr; return *this;}
 const int operator ==(const Elemento &val) const {return *ptr==*(val.ptr);}
 const int operator !=(const Elemento &val) const 
    {return !(*this==val);
    }
  universitario *getPtr()const{return ptr;}
  void print()const {ptr->print();}
};


main(){
List<Elemento> UnivParma;
studente uno_stud("Rossi","Luca",1979,"Ingegneria",5,25);
dipendente un_dip("Verdi","Alessandro",1943,27);
uno_stud.duplicate()->print();
Elemento el1(uno_stud);
Elemento el2(un_dip);
UnivParma.append(el1);
UnivParma.append(el2);
ListIterator<Elemento>  it(UnivParma);
it.current().print();
it.succ();
it.current().print();
cout<<"Inizio flush"<<endl;
UnivParma.flush();
cout<<"Fine flush" << endl;
}


/*
main(){
List<Elemento> UnivParma;
//studente uno_stud("Rossi","Luca",1979,"Ingegneria",5,25);
//dipendente un_dip("Verdi","Alessandro",1943,27);
//Elemento el1(uno_stud);
//Elemento el2(un_dip);
//UnivParma.putInFront(el1);
//UnivParma.putInFront(el2);
UnivParma.append(Elemento(dipendente("Verdi","Alessandro",1943,27)));
UnivParma.append(Elemento(studente("Rossi","Luca",1979,"Ingegneria",5,25)));
//UnivParma.append(el1);
//UnivParma.append(el2); 
//UnivParma.getFirst().print();
ListIterator<Elemento>  it(UnivParma);
it.current().print();
it.succ();
it.current().print();
return 1;
//studente altro_stud;
//altro_stud=uno_stud;
//un_dip.print();
//altro_stud.print();
// List<studente> L2;
// L2.append(altro_stud);
// L2.getFirst().print();
};

*/ 

// esempio di creazione di lista


/*

main()
   {
    studente uno_stud("Gatti","Alfredo",1976,"Fisica",4,9);
    professore un_prof("Alfieri","Mario",1947,16,"Informatica","Scienze");
    amministrativo un_amm("Verdi","Luigi",1950,8,"capo-ufficio","economato");
    uno_stud.print();
    un_prof.print();
    un_amm.print();
 
// modifico studente    
    uno_stud.set_cognome("Rossi");
    uno_stud.set_nome("Luca");
    uno_stud.set_anno_nascita(1976);
    uno_stud.set_corso_laurea("Ingegneria");
    uno_stud.set_anno_iscrizione(5);
    uno_stud.set_esami_sostenuti(25);
    uno_stud.print();
   
  }
  */



/*   ESEMPIO DI OUTPUT

       verdi> g++ university_list.C university_tst.C
verdi> a.out

Alfieri Mario
 anno di nascita: 1947
anzianita' di servizio: 16
Corso: Informatica Facolta': Scienze

Gatti Alfredo
 anno di nascita: 1978
Corso di Laurea: Fisica
anno iscrizione: 4 numero esami sostenuti: 9

Rossi Luca
 anno di nascita: 1976
Corso di Laurea: Ingegneria
anno iscrizione: 5 numero esami sostenuti: 25

Verdi Luigi
 anno di nascita: 1950
anzianita' di servizio: 8
Qualifica: capo-ufficio Ufficio: economato

tolgo Rossi e Verdi

Alfieri Mario
 anno di nascita: 1947
anzianita' di servizio: 16
Corso: Informatica Facolta': Scienze

Gatti Alfredo
 anno di nascita: 1978
Corso di Laurea: Fisica
anno iscrizione: 4 numero esami sostenuti: 9
verdi>

*/
