// Classi per la comunita' universitaria e classi derivate
// file pers_univ.C
//
// Usa il polimorfismo ( e le funzioni virtuali)
//

#include <stdio.h>
#include <string.h>
#include "iostream.h"
#include "ListeCaseStudy.C"

class universitario
{
  char cognome[15];
  char nome[15];
  int anno_nascita;
public:
  universitario(char* c,char* n,int a)
    {
     strcpy(cognome,c);
     strcpy(nome,n);
     anno_nascita=a;
    }
  universitario()
    {
     cognome[0]='\0';
     nome[0]='\0'; 
     anno_nascita=0;
    }
  universitario(const universitario & val) {*this=val;}  


  virtual universitario *duplicate() const {
     return new universitario((*this));
  }

  char *getkey(){return cognome;}

virtual universitario &operator =(const universitario &val){
     strcpy(cognome,val.cognome);
     strcpy(nome,val.nome);
     anno_nascita=val.anno_nascita;
     return *this;
  }

  const int operator ==(const universitario &val) const {return 1;}
  const int operator !=(const universitario &val) const 
    {return !(*this==val);
    }
   

  void set_cognome(char* cogn) {strcpy(cognome,cogn);}
  void set_nome(char* nom) {strcpy(nome,nom);}
  void set_anno_nascita(int a) {anno_nascita=a;}

  virtual void print()const
    {
     cout << endl << cognome << " " << nome << endl;
     cout << " anno di nascita: " << anno_nascita << endl;
     }

  virtual void insert(){}
};


class studente :public universitario
{

private: 
  char corso_laurea[15];
  int anno_iscrizione;
  int esami_sostenuti;

public:
  studente(char* n,char* c,int a,char* cl,int ai,int es):universitario(n,c,a)   
    {
     strcpy(corso_laurea,cl);
     anno_iscrizione=ai;
     esami_sostenuti=es;
    }
  studente():universitario()
    {
     corso_laurea[0]='\0';
     anno_iscrizione=0;
     esami_sostenuti=0;
    }
 
 studente (const studente & val) {*this=val;}
  
virtual studente *duplicate() const {
     return new studente((*this));
  }

 studente &operator =(const studente &val){
   universitario::operator =(val); 
     strcpy(corso_laurea,val.corso_laurea);
     anno_iscrizione=val.anno_iscrizione;
     esami_sostenuti=val.esami_sostenuti;
     return *this;
 }

  void set_corso_laurea(char* cl){strcpy(corso_laurea,cl);}
  void set_anno_iscrizione(int ai){anno_iscrizione=ai;}
  void set_esami_sostenuti(int es){esami_sostenuti=es;}

  void print()const
    {
     universitario::print();
     cout << "Corso di Laurea: " << corso_laurea << endl
          << "anno iscrizione: " << anno_iscrizione 
          << " numero esami sostenuti: " << esami_sostenuti << endl;  
    }
};


class dipendente : public universitario
{


 int anzianita_servizio;
public:
  dipendente(char* n,char* c,int a,int an_s):universitario(n,c,a)   
    {anzianita_servizio = an_s;}
  dipendente() : universitario()   
    {anzianita_servizio = 0;}

  dipendente (const dipendente & val) {*this=val;}
  virtual dipendente  *duplicate()const {
     return new dipendente((*this));
  }


  dipendente &operator =(const dipendente &val){
   universitario::operator =(val); 
     anzianita_servizio=val.anzianita_servizio;
     return *this;
 }
 
  
  void set_anzianita_servizio(int as){anzianita_servizio = as;}
 
  void print()const
    {
     universitario::print();
     cout << "anzianita' di servizio: " << anzianita_servizio  << endl;
      
     }
}; 


class professore :public dipendente
{
 
  char nome_corso[15];
  char facolta[15];
  
public:
  professore(char* n,char* c,int a,int as,char* nc,char* f):
           dipendente(n,c,a,as)
    {
     strcpy(nome_corso,nc); 
     strcpy(facolta,f);
    }
  professore():dipendente()
    {
     nome_corso[0]='\0'; 
     facolta[0]='\0';
    }

 professore (const professore & val) {*this=val;}

 virtual professore  *duplicate()const {
     return new professore((*this));
  }


 professore &operator =(const professore &val){
   dipendente::operator =(val); 
     strcpy(nome_corso,val.nome_corso);
     strcpy(facolta,val.facolta);
     return *this;
 }

  void set_nome_corso(char* nc){strcpy(nome_corso,nc);}
  void set_facolta(char* f){strcpy(facolta,f);}

  void print()const
    {
     dipendente::print();
     cout << "Corso: " << nome_corso << " Facolta': " << facolta << endl ; 
    }
}; 


class amministrativo :public dipendente
{
  char qualifica[15];
  char ufficio[15];
  
public:
  amministrativo(char* n,char* c,int a,int as,char* q,char* u):
        dipendente(n,c,a,as)
    {
     strcpy(qualifica,q); 
     strcpy(ufficio,u);
    }
  amministrativo():dipendente()
    {
     qualifica[0]='\0'; 
     ufficio[0]='\0';
    }

  amministrativo (const amministrativo & val) {*this=val;}

 virtual amministrativo  *duplicate()const {
     return new amministrativo((*this));
  }


 amministrativo &operator =(const amministrativo &val){
   dipendente::operator =(val); 
     strcpy(qualifica,val.qualifica);
     strcpy(ufficio,val.ufficio);
     return *this;
 }

  void set_qualifica(char* q){strcpy(qualifica,q);}
  void set_ufficio(char* u){strcpy(ufficio,u);}

  void print()const
    {
     dipendente::print();
     cout << "Qualifica: " << qualifica << " Ufficio: " << ufficio << endl ; 
    }

}; 






class Elemento {
universitario *ptr;
public: 
   Elemento(const universitario &val){
    ptr = val.duplicate();
    //  cout << "Costruttore Elemento ptr studente "<< ptr << endl;
  }  
  

 Elemento(const Elemento &val) {                     
     ptr=val.ptr->duplicate();
}
  
  ~Elemento(){ delete ptr;
  //  cout << "distruttore di Elemento ptr= " << ptr <<endl;
}
  Elemento &operator=(const Elemento &val) {ptr = val.ptr; return *this;}
 const int operator ==(const Elemento &val) const {return *ptr==*(val.ptr);}
 const int operator !=(const Elemento &val) const 
    {return !(*this==val);
    }
  char *getkey(){return ptr->getkey();}  
 universitario *getPtr()const{return ptr;}
  void print()const {ptr->print();}
};

// keycomp -> per l'ordinamento (overloading per i vari casi )

const int keycmp(Elemento El1, Elemento El2) 
     {return strcmp(El1.getkey(),El2.getkey());}
const int keycmp(Elemento El, char *key) {return strcmp(El.getkey(),key);}
const int keycmp(universitario Un1,universitario Un2)
     {return strcmp(Un1.getkey(),Un2.getkey());}
const int keycmp(universitario Un, char *key){return strcmp(Un.getkey(),key);}


void prova1(){
printf("\nFUNZIONE 1\n\n");
List<studente> ListaStudenti;
List<professore> ListaProfessori;
ListaStudenti.append(studente("Rossi","Luca",1979,"Ingegneria",5,25));
ListaProfessori.append(professore("Negri","Alessandro",1943,27,"informatica","Scienze"));
ListaStudenti.append(studente("Monteverdierdi","Claudio",1950,"Chimica",3,12));
ListaProfessori.append(professore("Alfieri","Mario",1947,16,"Informatica","Scienze"));
ListaStudenti.append(studente("Gatti","Alfredo",1976,"Fisica",4,9));
ListIterator<studente>  iter1(ListaStudenti);
printf("Lista Studenti: "); 
while (!iter1.terminate()) {
   iter1.current().print();
   iter1.succ();
  } 
puts("");
ListIterator<professore> iter2(ListaProfessori);
printf("Lista Professori: "); 
while (!iter2.terminate()) {
   iter2.current().print();
   iter2.succ();
  } 
puts("");

}

void prova2(){
printf("\nFUNZIONE 2\n\n");
OrderedList<studente,char *> ListaStudenti;
OrderedList<professore,char *> ListaProfessori;
ListaStudenti.insert(studente("Rossi","Luca",1979,"Ingegneria",5,25));
ListaProfessori.insert(professore("Negri","Alessandro",1943,27,"informatica","Scienze"));
ListaStudenti.insert(studente("Monteverdierdi","Claudio",1950,"Chimica",3,12));
ListaProfessori.insert(professore("Alfieri","Mario",1947,16,"Informatica","Scienze"));
ListaStudenti.insert(studente("Gatti","Alfredo",1976,"Fisica",4,9));
puts("ricerca e rimozione");
studente *studPtr=ListaStudenti.retrieve("Gatti");
if (studPtr) studPtr->print();
ListaStudenti.remove("Gatti");
puts("");
ListIterator<studente>  iter1(ListaStudenti);
printf("Lista Studenti: "); 
while (!iter1.terminate()) {
   iter1.current().print();
   iter1.succ();
  } 
puts("");
ListIterator<professore> iter2(ListaProfessori);
printf("Lista Professori: "); 
while (!iter2.terminate()) {
   iter2.current().print();
   iter2.succ();
  } 
puts("");
}

void prova3(){
printf("\nFUNZIONE 3\n\n");
OrderedList<Elemento,char *> UnivParma;
UnivParma.insert(Elemento(studente("Rossi","Luca",1979,"Ingegneria",5,25)));
UnivParma.insert(Elemento(professore("Negri","Alessandro",1943,27,"informatica","Scienze")));
UnivParma.insert(Elemento(amministrativo("Verdi","Luigi",1950,8,"capo-ufficio","economato")));
UnivParma.insert(Elemento(professore("Alfieri","Mario",1947,16,"Informatica","Scienze")));
UnivParma.insert(Elemento(studente("Gatti","Alfredo",1976,"Fisica",4,9)));

ListIterator<Elemento>  iter1(UnivParma);
printf("Lista Universitari : "); 
while (!iter1.terminate()) {
   iter1.current().print();
   iter1.succ();
  } 
puts("");
}

main(){
prova1();
prova2();
prova3();
}



  



/*   ESEMPIO DI OUTPUT

FUNZIONE 1

Lista Studenti: 
Rossi Luca
 anno di nascita: 1979
Corso di Laurea: Ingegneria
anno iscrizione: 5 numero esami sostenuti: 25

Monteverdierdi Claudio
 anno di nascita: 1950
Corso di Laurea: Chimica
anno iscrizione: 3 numero esami sostenuti: 12

Gatti Alfredo
 anno di nascita: 1976
Corso di Laurea: Fisica
anno iscrizione: 4 numero esami sostenuti: 9

Lista Professori: 
Negri Alessandro
 anno di nascita: 1943
anzianita' di servizio: 27
Corso: informatica Facolta': Scienze

Alfieri Mario
 anno di nascita: 1947
anzianita' di servizio: 16
Corso: Informatica Facolta': Scienze


FUNZIONE 2

ricerca e rimozione

Gatti Alfredo
 anno di nascita: 1976
Corso di Laurea: Fisica
anno iscrizione: 4 numero esami sostenuti: 9

Lista Studenti: 
Monteverdierdi Claudio
 anno di nascita: 1950
Corso di Laurea: Chimica
anno iscrizione: 3 numero esami sostenuti: 12

Rossi Luca
 anno di nascita: 1979
Corso di Laurea: Ingegneria
anno iscrizione: 5 numero esami sostenuti: 25

Lista Professori: 
Alfieri Mario
 anno di nascita: 1947
anzianita' di servizio: 16
Corso: Informatica Facolta': Scienze

Negri Alessandro
 anno di nascita: 1943
anzianita' di servizio: 27
Corso: informatica Facolta': Scienze


FUNZIONE 3

Lista Universitari : 
Alfieri Mario
 anno di nascita: 1947
anzianita' di servizio: 16
Corso: Informatica Facolta': Scienze

Gatti Alfredo
 anno di nascita: 1976
Corso di Laurea: Fisica
anno iscrizione: 4 numero esami sostenuti: 9

Negri Alessandro
 anno di nascita: 1943
anzianita' di servizio: 27
Corso: informatica Facolta': Scienze

Rossi Luca
 anno di nascita: 1979
Corso di Laurea: Ingegneria
anno iscrizione: 5 numero esami sostenuti: 25

Verdi Luigi
 anno di nascita: 1950
anzianita' di servizio: 8
Qualifica: capo-ufficio Ufficio: economato


*/
