/* 
ListeCaseStudy.C 

da Peter Muller Introduction to Object-Oriented Programming Using C++

*/

/*
Si vuole realizzare una classe per liste concatenate
La classe deve essere generica nel senso che l'elemento base della
lista non viene specificato.
Si fa ricorso ai templates


template <class T>
class List:...{
public:
 ...
 void append(cons T data);
 ...
};

dove T e' un "placeholder" 

Istanze di classi Lista possono essere create specificando il valore di T

List<int> integerList;

*/

/*  Bisogna distinguere fra "shape" e "traversal"

con "shape" si intende la visione dei blocchi che costituiscono 
la struttura dati  
con "traversal" si intende la strategia di visita della struttura
Si dovranno fornire degli iteratori che permettano di ottenere:
   - L'elemento corrente
   - L'elementosuccessore
   - La condizione di terminazione 



   */


#include <stdio.h>
#include "iostream.h" 
/* progettazione dello SHAPE 
Per quanto riguarda i nodi della lista questi possono contenere solo
il puntatore al nodo successore*/

class Node {
  Node *_right;

public:   
  Node(Node *right = NULL) : _right(right){} // costruttore
  Node(const Node &val) : _right(val._right){} // costruttore di copia
  
  const Node *right() const {return _right;} // selettore const !!!!!!!!
  Node *&right() {return  _right;}           // selettore ritorna un reference 

  Node &operator =(const Node &val) {    // assegnamento
    _right = val._right;
    return *this;
  }
  
  const int operator ==(const Node &val) const {   // confronto
    return _right == val._right;
  }
  const int operator !=(const Node &val) const {
    return !(*this==val) ;
  }
};
 

/*
    La classe Node deve essere specializzata per inserire i dati 
    Poiche' il tipo dei dati non e' specificato si usa una classe generica 
    con template

*/

template <class T>
class DataNode : public Node {   //eredita da Node
  T _data;                       //aggiunge il campo dati
public : // specializza i costruttori
  DataNode(const T &data, DataNode *right = NULL):
	   Node(right), _data(data) {
	     cout << "costruttore DataNode" <<endl;
             _data.print();}
  DataNode(const DataNode &val): Node(val),_data(val._data){}

  //accesso al nodo successivo
  const DataNode *right() const {
    return ((DataNode *) Node::right());
  }
    DataNode *&right() {return((DataNode *&) Node::right());}

  // accesso alla parte dati
  const T &data() const { return _data;}
  T &data() {return _data;}

  DataNode &operator =(const DataNode &val){
    Node::operator =(val); 
    _data = val._data;
    return *this;
  }

  const int operator ==(const DataNode &val) const{
    return(
	   Node::operator ==(val) &&
           _data == val._data);     
  }
  const int operator !=(const DataNode &val) const {
     return !(*this==val);
  }
        
};     


/* classe base per tutti i tipi di liste 
 e' una classe astratta */ 

template <class T>
class ListBase {
public:
  virtual ~ListBase(){} // Il distruttore deve essere virtuale
  virtual void flush()=0;
  
  virtual void putInFront(const T &data) = 0;
  virtual void append(const T &data) = 0; 
  virtual void delFromFront() = 0;

  virtual const T &getFirst() const = 0;
  virtual T &getFirst() = 0;
  virtual const T &getLast() const = 0;
  virtual T &getLast() = 0;
  
  virtual const int isEmpty() const = 0;
};


// definizione effettiva della classe List

template <class T>
class List : public ListBase<T> {
  DataNode<T> *_head, *_tail;

public:
  List() : _head(NULL), _tail(NULL){}
  List(const List &val) : _head(NULL), _tail(NULL) {
    *this = val;
  }
  virtual ~List(){flush();}
  virtual void flush(){
  DataNode<T> *walkp = _head,
              *ptr = _head;
  while (walkp) {
    walkp = walkp -> right();
    delete ptr;
    ptr = walkp;  
    }
  _head = _tail = NULL;
  };
  
  virtual void putInFront(const T &data);
  virtual void append(const T &data);
  virtual void delFromFront();
  
  virtual const T &getFirst() const { return _head->data();}
  virtual T &getFirst() { 
     cout << "getFirst ptr  "<< _head->data().getPtr() << endl;
     cout << "print da getFirst" << endl; 
     _head->data().print();
    return _head->data();}
  virtual const T &getLast() const { return _tail->data();}
  virtual T &getLast() { return _tail->data();}

  virtual const int isEmpty() const {return _head==NULL;}

  List &operator =(const List &val) {
  flush();
  DataNode<T> *walkp = val._head;
  while (walkp) {
    append(walkp->data());
    walkp = walkp-> right();
  }
  return *this;
    }

  const int operator ==(const List &val) const{
    if (isEmpty() && val.isEmpty()) return 1;
          DataNode<T> *thisp = _head,
                      *valp =val._head; 
    while (thisp && valp) { 
       if (thisp->data() != valp->data()) return 0;
       thisp = thisp->right();
       valp = valp->right();
    }
    return 1;
  }

  const int operator !=(const List &val) const {
    return !(*this == val);
  }

  friend class ListIterator<T>;
  };  


template <class T> void
List<T>::putInFront(const T &data){
  _head = new DataNode<T>(data,_head);
  cout << "putInFront.... "<< endl;
  cout << "ptr= " << _head->data().getPtr() << endl;
  _head -> data().print();
  if (!_tail) _tail = _head;
} // putInFront 

template <class T> void            // controllare
List<T>::append(const T &data){
  cout << " append l'originale......... " << endl;
  data.getPtr()->print();
  DataNode<T> *ptr = new DataNode<T>(data,NULL);
  cout << "append la copia ........." <<endl;
  ptr->data().print();
  if (!_tail) _tail = _head = ptr;
  else {_tail->right() = ptr;
  _tail = ptr;
  }
}   // append 

template <class T> void
List<T>::delFromFront(){
  DataNode<T> *old_head(_head);
  if(_head)
  _head = _head->right();
  delete old_head;
  if (!_head) _tail = NULL;;
} // delFromFront




template <class Data, class Element>
class Iterator {
protected:
Element _start,
        _current;

public:
  Iterator(const Element start) :
    _start(start),_current(start){}
  Iterator(const Iterator &val) :
    _start(val._start),_current(val._current) {}
  virtual ~Iterator(){}
  
 virtual const Data current() const = 0;
 virtual void succ() = 0;
 virtual const int terminate() const = 0;

 virtual void rewind(){_current = _start;}
 Iterator &operator =(const Iterator &val) {
   _start = val._start;
   _current = val._current;
  return *this;
 }

  const int operator ==(const Iterator &val) const {
   return(_start == val._start && _current == val.current);
  }

  const int operator !=(const Iterator &val) const {
    return !(*this == val);
  }   
};

template <class T>
class ListIterator : public Iterator<T, DataNode<T> *> {

public:
  ListIterator(const List<T> &list):
    Iterator<T, DataNode<T> *> (list._head){}
  ListIterator(const ListIterator  &val):
    Iterator<T, DataNode<T> *> (val){}

  virtual const T current() const {return _current->data();}
  virtual void succ() { _current = _current->right();}
  virtual const int terminate() const {
    return _current==NULL;
  }

  T &operator ++(int) {
   T &tmp = _current->data();
   succ();
   return tmp;
  }

  ListIterator &operator =(const ListIterator &val) {
    Iterator<T,DataNode<T> *>::operator =(val);
    return *this;
  }
};


/*


// main 


int  main() {
const Node n1;
Node n2(n1);
Node n3;
n1.right();
n3=n2.right();
const Node n4(n2.right());
  

const DataNode<int> dn(6,(DataNode<int> *&) n1);
dn.right();

List<int> list;


int ix;

//for (ix=0; ix <= 10; ix++) list.putInFront(ix);
for (ix=0; ix <= 10; ix++) list.append(ix);
const List<int> list1(list);
//  list1.append(100);  // errore list1 e' costante
list.flush();
list.append(32);
ListIterator<int> iter(list);
while (!iter.terminate()) {
   printf("%d",iter.current());
   iter.succ();
  } 
puts("");
ListIterator<int> iter1(list1);
while (!iter1.terminate()) {
   printf("%d",iter1.current());
   iter1.succ();
  } 
puts("");

}

*/
