/* 
ListeCaseStudy.C 

da Peter Muller Introduction to Object-Orien
ted Programming Using C++

*/

/*
Si vuole realizzare una classe per liste concatenate
La classe deve essere generica nel senso che l'elemento base della
lista non viene specificato.
Si fa ricorso ai templates


template <class T>
class List:...{
public:
 ...
 void append(cons T data);
 ...
};

dove T e' un "placeholder" 

Istanze di classi Lista possono essere create specificando il valore di T

List<int> integerList;

*/

/*  Bisogna distinguere fra "shape" e "traversal"

con "shape" si intende la visione dei blocchi che costituiscono 
la struttura dati  
con "traversal" si intende la strategia di visita della struttura
Si dovranno fornire degli iteratori che permettano di ottenere:
   - L'elemento corrente
   - L'elementosuccessore
   - La condizione di terminazione 



   */


#include <stdio.h>
#include "iostream.h" 
/* progettazione dello SHAPE 
Per quanto riguarda i nodi della lista questi possono contenere solo
il puntatore al nodo successore*/

class Node {
  Node *_right;

public:   
  Node(Node *right = NULL) : _right(right){} // costruttore
  Node(const Node &val) : _right(val._right){} // costruttore di copia
  
  const Node *right() const {return _right;} // selettore const !!!!!!!!
  Node *&right() {return  _right;}           // selettore ritorna un reference 

  Node &operator =(const Node &val) {    // assegnamento
    _right = val._right;
    return *this;
  }
  

  const int operator ==(const Node &val) const {   // confronto
    return _right == val._right;
  }
  const int operator !=(const Node &val) const {
    return !(*this==val) ;
  }
};
 

/*
    La classe Node deve essere specializzata per inserire i dati 
    Poiche' il tipo dei dati non e' specificato si usa una classe generica 
    con template

*/

template <class T>
class DataNode : public Node {   //eredita da Node
  T _data;                       //aggiunge il campo dati
public : // specializza i costruttori
  DataNode(const T &data, DataNode *right = NULL):
	   Node(right), _data(data) {}
  DataNode(const DataNode &val): Node(val),_data(val._data){}

  //accesso al nodo successivo
  const DataNode *right() const {
    return ((DataNode *) Node::right());
  }
    DataNode *&right() {return((DataNode *&) Node::right());}

  // accesso alla parte dati
  const T &data() const { return _data;}
  T &data() {return _data;}

  DataNode &operator =(const DataNode &val){
    Node::operator =(val); 
    _data = val._data;
    return *this;
  }

  const int operator ==(const DataNode &val) const{
    return(
	   Node::operator ==(val) &&
           _data == val._data);     
  }
  const int operator !=(const DataNode &val) const {
     return !(*this==val);
  }
        
};     


/* classe base per tutti i tipi di liste 
 e' una classe astratta */ 
/*

template <class T>
class ListBase {
public:
  virtual ~ListBase(){} // Il distruttore deve essere virtuale
  virtual void flush()=0;
  
  virtual void putInFront(const T &data) = 0;
  virtual void append(const T &data) = 0; 
  virtual void delFromFront() = 0;

  virtual const T &getFirst() const = 0;
  virtual T &getFirst() = 0;
  virtual const T &getLast() const = 0;
  virtual T &getLast() = 0;
  
  virtual const int isEmpty() const = 0;
};
*/

// definizione della classe List

template <class T>
class List {

protected:
  DataNode<T> *_head, *_tail;

public:
  List() : _head(NULL), _tail(NULL){}
  List(const List &val) : _head(NULL), _tail(NULL) {
    *this = val;
  }
  virtual ~List(){flush();}
  void flush(){
  DataNode<T> *walkp = _head,
              *ptr = _head;
  while (walkp) {
    walkp = walkp -> right();
    delete ptr;
    ptr = walkp;  
    }
  _head = _tail = NULL;
  };
  
  // inserimento e cancellazione
  void putInFront(const T &data);
  void append(const T &data);
  void delFromFront();

  // primo e ultimo elemento
  const T &getFirst() const { return _head->data();}
  T &getFirst() {return _head->data();}
  const T &getLast() const { return _tail->data();}
  T &getLast() { return _tail->data();}

  
  
  //lista vuota
  const int isEmpty() const {return _head==NULL;}

  //assegnamento
  List &operator =(const List &val) {
  flush();
  DataNode<T> *walkp = val._head;
  while (walkp) {
    append(walkp->data());
    walkp = walkp-> right();
  }
  return *this;
    }

  //confronto
  const int operator ==(const List &val) const{
    if (isEmpty() && val.isEmpty()) return 1;
          DataNode<T> *thisp = _head,
                      *valp =val._head; 
    while (thisp && valp) { 
       if (thisp->data() != valp->data()) return 0;
       thisp = thisp->right();
       valp = valp->right();
    }
    return 1;
  }

  const int operator !=(const List &val) const {
    return !(*this == val);
  }

  friend class ListIterator<T>;
  };  



// implementazione classe liste

template <class T> void
List<T>::putInFront(const T &data){
  _head = new DataNode<T>(data,_head);
  if (!_tail) _tail = _head;
} // putInFront 

template <class T> void         
List<T>::append(const T &data){
  DataNode<T> *ptr = new DataNode<T>(data,NULL);
  if (!_tail) _tail = _head = ptr;
  else {_tail->right() = ptr;
  _tail = ptr;
  }
}   // append 

template <class T> void
List<T>::delFromFront(){
  DataNode<T> *old_head(_head);
  if(_head)
  _head = _head->right();
  delete old_head;
  if (!_head) _tail = NULL;;
} // delFromFront

// Iteratore - l'iteratore permette di visitare la struttura dati
// in un ordine definito. da sinistra a destra per una lista.        


template <class T>
class ListIterator{

protected:
DataNode<T> *_start,
            *_current;

public:
  ListIterator(const List<T> &list):
    _start(list._head),_current(list._head){}
  ListIterator(const ListIterator  &val):
    _start(val._start),_current(val._current){}

  const T current() const {return _current->data();}
  void succ() { _current = _current->right();}
  const int terminate() const {
    return _current==NULL;
  }

  T &operator ++() {
   T &tmp = _current->data();
   succ();
   return tmp;
  }


void rewind(){_current = _start;}

 ListIterator &operator =(const ListIterator &val) {
   _start = val._start;
   _current = val._current;
  return *this;
}  
  /*  const int operator ==(const ListIterator &val) const {
   return(_start == val._start &&_current == val.current));
  }
  const int operator !=(const ListIterator &val) const {
    return !(*this == val);
  } */  
};

template <class T, class K>
class OrderedList : public  List<T> {

public:

void insert(T data){
DataNode<T> *current(_head),
            *previous(NULL);   
if (_head){                        // lista non vuota
  while(current != NULL && (keycmp(current->data(), data) <= 0)){
    previous = current;
     current = current -> right();
  }
  if (!previous)   // si deve inserire come primo 
    _head=new DataNode<T>(data,current);
   else 
     previous->right()=new DataNode<T>(data,current);
}
else{_head=_tail=new DataNode<T>(data,NULL);}  //lista vuota
}  // insert


void remove(K key){
DataNode<T> *current(_head),
            *previous(NULL);   
if (_head){                        // lista non vuota
  while(current != NULL && (keycmp(current->data(), key) < 0)){
    previous = current;
     current = current -> right();
  }
  if (keycmp(current->data(),key)==0)   // ok trovato
  if (!previous)   // si deve rimuovere il primo 
   { _head=current->right();
   delete current;}
   else 
     {
    (*previous).Node::operator =(current->right());
    delete current;}
}

}  // remove


  // cerca un nodo in base alla chiave 
  // ritorna un puntatore ai dati o NULL se non lo trova
T *retrieve(K key){
DataNode<T> *current(_head);   
if (_head){                        // lista non vuota
  while(current != NULL && (keycmp(current->data(), key) < 0)){
     current = current -> right();
  }
  if (keycmp(current->data(),key)==0)   // ok trovato
   return &(current->data());
  else
   return NULL;
   
}

}  // retrieve
};

// ordinamento decrescente per gli interi
// const int keycmp(const int int1, const int int2) {return int2 - int1;}

/*

main(){
// lista di interi e relativo iteratore
OrderedList<int,int> list;
int ix;
int *pi;
for (ix=0; ix <= 10; ix+=2) list.insert(ix);
for (ix=1; ix <= 10; ix+=2) list.insert(ix);
pi= list.retrieve(0);
if (pi) cout << "retrieve: "<< *pi << endl;
  else cout << "retrieve: non trovato" << endl;
list.remove(10);
printf("list : "); 
ListIterator<int> iter(list);
while (!iter.terminate()) {
   printf("%3d",iter.current());
   iter.succ();
  } 
puts("");
}
*/

/*
Attila.Eng.UniPR.IT> a.out
retrieve: 0
list :   9  8  7  6  5  4  3  2  1  0
Attila.Eng.UniPR.IT> 
*/
/*
int  main() {
// Test delle classi Node e DataNode
const Node n1;
Node n2(n1);
Node n3;
n1.right();
n3=n2.right();
const Node n4(n2.right());
  
const DataNode<int> dn(6,(DataNode<int> *&) n1);
dn.right();


// lista di interi e relativo iteratore
List<int> list;
int ix;
for (ix=0; ix <= 10; ix++) list.putInFront(ix);
for (ix=0; ix <= 10; ix++) list.append(ix);
printf("list : "); 
ListIterator<int> iter(list);
while (!iter.terminate()) {
   printf("%3d",iter.current());
   iter.succ();
  } 
puts("");
for (ix=0; ix <= 10; ix++) list.delFromFront();

// list1 e' una copia di list - e' una lista const
const List<int> list1(list);
// list1.append(100);  // errore list1 e' costante
ListIterator<int> iter1(list1);
printf("list1: "); 
while (!iter1.terminate()) {
   printf("%3d",iter1.current());
   iter1.succ();
  } 
puts("");
return 0;
}


  */
/*
Attila.Eng.UniPR.IT> a.out
list :  10  9  8  7  6  5  4  3  2  1  0  0  1  2  3  4  5  6  7  8  9 10
list1:   0  1  2  3  4  5  6  7  8  9 10
Attila.Eng.UniPR.IT> 
*/






