#include <iostream>
#include <vector>
#include <string>
#include "vita.h"
using namespace std;


Cella::Cella(){
		stato=0;
		nuovoStato=0;
	}
void Cella::aggiornaCella() {
		stato=nuovoStato;
	}


		
Griglia::Griglia(string s) {
		const string strAliante="aliante";
		const string strBlinker="blinker";
		const string strEsagono="esagono";
		const string strBlocco="blocco";
		const string strDueAlianti="due";
		numRighe=10;
		numColonne=10;
		cicloVita=0;
		
		// se si usa un vector qui si inizializza la griglia !!!!
		Grid.resize(numRighe,vector<Cella>(numColonne,Cella()));


		// questa parte serve a inizializzare una figura nella griglia
        
		// aliante
		if (strAliante.compare(0,s.size(),s)==0) {
		Grid[0][1].stato = 1;
		Grid[1][2].stato = 1;
		Grid[2][2].stato = 1;
		Grid[2][1].stato = 1;
		Grid[2][0].stato = 1;
		}
		// blinker 
		else if (strBlinker.compare(0,s.size(),s)==0) {
		Grid[0][1].stato = 1;
		Grid[1][1].stato = 1;
		Grid[2][1].stato = 1;
		}
		// esagono
		else if (strEsagono.compare(0,s.size(),s)==0) {
		Grid[0][1].stato = 1;
		Grid[1][0].stato = 1;
		Grid[1][2].stato = 1;
		Grid[2][0].stato = 1;
		Grid[2][2].stato = 1;
		Grid[3][1].stato = 1;
		}
		// due alianti che si scontrano
		else if (strDueAlianti.compare(0,s.size(),s)==0) {
		Grid[0][1].stato = 1;
		Grid[1][2].stato = 1;
		Grid[2][2].stato = 1;
		Grid[2][1].stato = 1;
		Grid[2][0].stato = 1;
		Grid[0][8].stato = 1;
		Grid[1][7].stato = 1;
		Grid[2][7].stato = 1;
		Grid[2][8].stato = 1;
		Grid[2][9].stato = 1;
		}
		// blocco
		else if (strBlocco.compare(0,s.size(),s)==0) {
		Grid[1][1].stato = 1;
		Grid[1][2].stato = 1;
		Grid[2][1].stato = 1;
		Grid[2][2].stato = 1;
		}
		// altro.. esco
		else {
			cout << "Figura non valida! ";
			exit(0);
		}
	}
	
	// visualizza la griglia come matrice di {0,1}
void Griglia::visualizza() {
		for (int riga=0; riga < numRighe; riga++) {
			for (int colonna=0; colonna < numColonne; colonna++) {
				cout << Grid[riga][colonna].stato ;
			}
			cout << endl;
		}
	cout << endl;
	}
	
	// per la cella di posizione r,c calcola il numero di celle
	// vive nel vicinato e applica le regole del gioco della vita

void Griglia::applicaRegole(int r, int c) {
		int rpiu = (r+1) % numRighe;
		int rmeno = ((r-1)+numRighe) % numRighe;
		int cpiu = (c+1) % numColonne;
		int cmeno = ((c-1)+numColonne) % numColonne;
		// calcola quanti vicini sono vivi...
		int sommaVicini = Grid[rpiu][cmeno].stato+Grid[rpiu][c].stato+
			Grid[rpiu][cpiu].stato+
			Grid[r][cmeno].stato+Grid[r][cpiu].stato+
			Grid[rmeno][cmeno].stato+Grid[rmeno][c].stato+
			Grid[rmeno][cpiu].stato;
		// applica la regola del gioco calcolando nuovo stato				  
			if (Grid[r][c].stato==1) 
				if ((sommaVicini==2) || (sommaVicini == 3)) 
					Grid[r][c].nuovoStato=1;
				else 
					Grid[r][c].nuovoStato=0;
			else
				if (sommaVicini==3) 
					Grid[r][c].nuovoStato=1;
				else 
					Grid[r][c].nuovoStato=0;
	}

	// dopo aver calcolato il nuovo stato per tutte le celle 
	// si procede all' aggiornamento in modo sincrono della griglia
void Griglia::aggiornaCelle() {
		int riga,colonna;
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				applicaRegole(riga,colonna) ;
			}
		}
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				Grid[riga][colonna].aggiornaCella() ;
			}
		}
	}


	// un sequenza di cicli di aggiornamento e relativa visualizzazione
void Griglia::cicloVitale(){
		cout << "ciclo: " << cicloVita  ;
		cout << ", premi un tasto per continuare, CTRL-Z per finire " << endl;
		cin.get();
		while(cin.get() != EOF) {
			aggiornaCelle();
	        visualizza();
			cicloVita++;
			cout << "ciclo: " << cicloVita  ;
			cout << ", premi un tasto per continuare, CTRL-Z per finire " << endl;
		}
	}




/*
Stato 	N. Vicine	Risultato		
casella	occupate			
occup.	0,1				0		
1		2,3				1		
		4,5,6,7,8		0		
vuota	0,1,2			0		
0		3				1		
		4,5,6,7,8		0		

*/

void main(){
	string figura;
	cout << "aliante, blinker, esagono, blocco o due (alianti)? " << flush;
	cin >> figura;
	cout << endl; 
	Griglia g(figura);
	g.visualizza();
	g.cicloVitale();
}
