
/*
 Dario Bianchi

  Integrazione con la regola di SIMPSON
   
	 calcola l 'integrale definito di una funzione f(x) nell' intevallo a,b
	 l' intervallo (a,b) viene diviso in 2n parti x[0],...x[2n]
l' integrale vale:

  (h/3)*(f(x[0]) + 4 * f(x[1]) + 2 * f(x[2]) + 
     .... + 4 * f(x[2n-1]) + f(x[2n]))

dove  h=(x[2n]-x[0]) / (2n)  (intervallo di integrazione) 
n = numero di integrali fatti (fra 3 punti con approssimazione parabolica)
Nel programma il risultato viene confrontato con l' integrale calcolato
con la regola dei trapezi.

*/

#include <iostream>
#include <iomanip>
#include <math.h>
#include <vector>

using namespace std;


double fun(double x) {
	return sin(x);
}

void main() {

vector<double> x;
vector<double> f;
// estremi di integrazione 
const double a=0.0;
const double b=3.141590;
int n;
double h;
double simpson = 0;
double trapezi = 0;
cout << "calcolo dell' integrale definito di sen(x) fra 0 e PiGreco " << endl;
cout << "quanti intervalli di integrazione ? " << flush;
cin >> n;
x.resize(2*n+1);
f.resize(2*n+1);
h= (b-a) / (2*n) ;

// calcola la funzione

for (int i= 0; i<=2*n; i++) {
	x[i] = a+ i * h;
	f[i] = fun(x[i]);
}

//calcola l' integrale

simpson = f[0] + 4 * f[1];
for (i= 2; i<2*n ; i= i+2) {
	simpson = simpson + 2 * f[i] + 4 * f[i+1] ;
}
simpson = simpson + f[2*n];
simpson = simpson * h / 3;

// tarpezi per confronto
trapezi =0;
for (i=0; i<2 *n ; i=i+1){
	trapezi = trapezi + (f[i] + f[i+1] ) * h / 2; 
}

// stampa il risultato

cout << " l'integrale calcolato con la regola di  Simpson di vale: " 
	<< setprecision(12) << simpson << endl;
cout << " l'integrale calcolato con la regola dei trapezi di vale: " 
	<< setprecision(12) << trapezi << endl;
cin.get();
cout << "Premi un tasto per finire. "<< flush;
cin.get();

}
