//**************************************************************************
//
// Copyright (c) 1997.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/15/96
// $Revision: 1.1 $
// $Name: P2 P1 $
//
//**************************************************************************

// rational.h: declaration of Rational ADT
#ifndef RATIONAL_H
#define RATIONAL_H

#include <iostream>
#include <string>

using namespace std;

// Rational ADT: class description
class Rational {
	public: // member functions
		// constructors
		Rational();
		Rational(int numer, int denom = 1);
		// some arithmetic and stream facilitators
		Rational Add(const Rational &r) const;
		Rational Multiply(const Rational &r) const;
		// confronto
		bool Equal(const Rational &r) const;
		bool LessThan(const Rational &r) const;
		bool LessEqual(const Rational &r) const;
		void Insert(ostream &sout) const;
		void Extract(istream &sin);
	protected:
		// inspectors
		int Numerator() const;
		int Denominator() const;
		// mutators
		void SetNumerator(int numer);
		void SetDenominator(int denom);
	private:
		// data members
		int NumeratorValue;
		int DenominatorValue;
};

// Rational ADT: auxiliary operator description
Rational operator+(const Rational &r,
	const Rational &s);
Rational operator*(const Rational &r,
	const Rational &s);
// Operatori di confronto
bool operator==(const Rational &r,
	const Rational &s);
bool operator<(const Rational &r,
	const Rational &s);
bool operator<=(const Rational &r,
	const Rational &s);

ostream& operator<<(ostream &sout, const Rational &s);
istream& operator>>(istream &sin, Rational &r);

#endif


