//**************************************************************************
//
// Copyright (c) 1997.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/15/96
// $Revision: 1.1 $
// $Name: P2 P1 $
//
//**************************************************************************

#include <iostream>
#include <string>
#include "rational.h"

using namespace std;

// default constructor
Rational::Rational() {
	SetNumerator(0);
	SetDenominator(1);
}

// (numer, denom) constructor
Rational::Rational(int numer, int denom) {
	SetNumerator(numer);
	SetDenominator(denom);
}

// get the numerator
int Rational::Numerator() const {
	return NumeratorValue;
}

// get the denominator
int Rational::Denominator() const {
	return DenominatorValue;
}

// set the numerator
void Rational::SetNumerator(int numer) {
	NumeratorValue = numer;
}

// set the denominator
void Rational::SetDenominator(int denom) {
	if (denom != 0)
		DenominatorValue = denom;
	else {
		cerr << "Illegal denominator: " << denom
		<< "using 1" << endl;
		DenominatorValue = 1;
	}
}

// adding Rationals
Rational Rational::Add(const Rational &r) const {
	int a = Numerator();
	int b = Denominator();
	int c = r.Numerator();
	int d = r.Denominator();
	return Rational(a*d + b*c, b*d);
}

// multiplying Rationals
Rational Rational::Multiply(const Rational &r) const {
	int a = Numerator();
	int b = Denominator();
	int c = r.Numerator();
	int d = r.Denominator();
	return Rational(a*c, b*d);
}

// comparing Rationals EQUAL
bool Rational::Equal(const Rational &r) const {
	int a = Numerator();
	int b = Denominator();
	int c = r.Numerator();
	int d = r.Denominator();
	return ((a*d)==(b*c));
}

// comparing Rationals LessThan
bool Rational::LessThan(const Rational &r) const {
	int a = Numerator();
	int b = Denominator();
	int c = r.Numerator();
	int d = r.Denominator();
	return (a*d)<(b*c);
}

// comparing Rationals LessEqual
bool Rational::LessEqual(const Rational &r) const {
	int a = Numerator();
	int b = Denominator();
	int c = r.Numerator();
	int d = r.Denominator();
	return (a*d)<=(b*c);
}

// inserting a Rational
void Rational::Insert(ostream &sout) const {
	sout << Numerator() << '/' << Denominator();
	return;
}

// extracting a Rational
void Rational::Extract(istream &sin) {
	int numer;
	int denom;
	char slash;
	sin >> numer >> slash >> denom;
	SetNumerator(numer);
	SetDenominator(denom);
	return;
}

// adding Rationals
Rational operator+(const Rational &r,
const Rational &s) {
	return r.Add(s);
}

// multiplying Rationals
Rational operator*(const Rational &r,
const Rational &s) {
	return r.Multiply(s);
}

// comparing Rationals Equal
bool operator==(const Rational &r,
const Rational &s) {
	return r.Equal(s);
}

// comparing Rationals LessThan
bool operator<(const Rational &r,
const Rational &s) {
	return r.LessThan(s);
}

// comparing Rationals LessEqual
bool operator<=(const Rational &r,
const Rational &s) {
	return r.LessEqual(s);
}

// inserting a Rational
ostream& operator<<(ostream &sout, const Rational &r) {
	r.Insert(sout);
	return sout;
}

// extracting a Rational
istream& operator>>(istream &sin, Rational &r) {
	r.Extract(sin);
	return sin;
}


