

#include <vector>
#include <iostream>
using namespace std;


/* 
	
	Definisce  una serie di funzioni Template 
	per leggere e stampare un vector, per ordinarlo e
	per effettuare una ricerca binaria.
	Queste funzini si applicano anche per dei vector di Rational.
	Infatti per la classe Rational sono ridefiniti gli operatori di
	inserimento ed estrazione ( <<  >>). 
*/	


/*

// Usando il polimorfismo .......

// Legge dall' input i valori interi

void GetValues(vector<int> &Vect) {
	Vect.resize(0);
	int Val;
	while (cin >> Val) Vect.push_back(Val);
};
// Legge dall' input stringhe

void GetValues(vector<string> &Vect) {
	Vect.resize(0);
	string Val;
	while (cin >> Val) Vect.push_back(Val);
};
// Legge dall' input valori Rational

void GetValues(vector<Rational> &Vect) {
	Vect.resize(0);
	Rational Val;
	while (cin >> Val) Vect.push_back(Val);
};

*/

// Legge dall' input valori T e li inserisce in un vector
template <class T>
void GetValues(vector<T> &Vect) {
	Vect.resize(0);
	T Val;
	while (cin >> Val) Vect.push_back(Val);
	// resetta i flags di stato del file. Altrimenti l' eof rimane settato.
	cin.clear();
};

// Mostra i valori del vector sull' output
template <class T>
void DisplayValues(vector<T> &Vect) {
	int dim = Vect.size();
	for (int i=0 ; i< dim ; i++) {
		cout << Vect[i] << " ";
	}
	cout << endl;
}


// Mostra i valori del vector sull' output
// Usa un iteratore
template <class T>
void DisplayValuesIter(vector<T> &Vect) {
	vector<T>::iterator iter;   // Definisce un iteratore
	for (iter=Vect.begin(); iter < Vect.end() ; iter++) {
		cout << *iter << " ";
	}
	cout << endl;
}


// Selection Sort
// On ith iteration place the ith smallest element in the ith list location
template <class T> 
void SelectionSort(vector<T> &A) {
	int n = A.size();
	for (int i = 0; i < n; ++i) {
	int k = i;
	for (int j = i + 1; j < n; ++j) {
	if (A[j] < A[k])
	k = j;
	}
	if (i != k)
	swap(A[k], A[i]);
	}
}




// BinarySearch(): examine sorted list A for Key
template <class T>
int BinarySearch(vector<T> &A, T &Key) {
	int n = A.size();
	int left = 0;
	int right = n-1;
	while (left <= right) {
		int mid = (left + right)/2;
		if (A[mid] == Key)
			return mid;
		else if (A[mid] < Key)
			left = mid + 1;
		else
			right = mid - 1;
	}
	return n;
}
;




