
/*
 Dario Bianchi ottobre 2002
 Programma per il plot di una serie di punti 
 inseriti da tastiera o da file
 */

#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include "rect.h"
#include "ray.h"
using namespace std;




// rappresenta un punto da graficare //
class Point {
public:
	float x;
	float y;
	Point() {
		x=0;
		y=0;
	}
	Point(double xVal, double yVal) {
		x=xVal;
		y=yVal;
	}

};

// legge i dati da uno stream (stdin o file)
void leggiDati(istream &is, vector<Point> &Vect) {
	double xVal,yVal;
	Vect.resize(0);
	while (is >> xVal) {		
		is >> yVal;
		Vect.push_back(Point(xVal,yVal));
	}
	cout << "numero dati letti:" << Vect.size() << endl;
	cout << "coordinate dei punti: " << endl;
	for (int i=0; i < Vect.size(); i++) {
		cout << '[' << i << "] " << Vect[i].x <<" "<< Vect[i].y << endl;
	}
}

// legge i dati da tastiera 
void leggiDatiDaTastiera(vector<Point> &Vect) {
	leggiDati(cin, Vect);   // legge dallo stream cin fini a CTRL-Z
	cin.clear();			// togle l' EOF su cin
}

void leggiDatiDaFile(vector<Point> &Vect) {
	cout << "I dati verranno letti dal file dati.txt nella dir corrente" << endl;
	ifstream sin("dati.txt");  // apre il file NB nome fisso !!!
	if (!sin) { cerr << "impossibile aprire il file!" << endl; exit(0);}
	leggiDati(sin,Vect);       // lettura dati
	}

/*
// Leggi dati separate da tastiera e da file
void leggiDatiDaTastiera(vector<Point> &Vect) {
	double xVal,yVal;
	Vect.resize(0);
	while (cin >> xVal) {		
		cin >> yVal;
		Vect.push_back(Point(xVal,yVal));
	}
	cin.clear();
	cout << "dati letti:" << Vect.size() << endl;

}

void leggiDatiDaFile(vector<Point> &Vect) {
	cout << "I dati verranno letti dal file dati.txt nella dir corrente" << endl;
	ifstream sin("dati.txt");
	if (!sin) { cerr << "impossibile aprire il file!" << endl; exit(0);}
	double xVal,yVal;
	Vect.resize(0);
	while (sin >> xVal) {		
		sin >> yVal;    
		Vect.push_back(Point(xVal,yVal));
	}
	sin.close();
	cout << "dati letti:" << Vect.size() << endl;
}
*/


/* determina i fattori di scala, scala il vettore dei punti
	e traccia gli assi */
void scala(SimpleWindow &W, vector<Point> &Vect) {
	float WinDimX = W.GetWidth() - 1;
    float WinDimY = W.GetHeight() - 1;
	
	float xOffSet =0.5;
	float yOffSet =0.5; 
	float thick = 0.015;
	// determina massimi e minimi di x e y
	float xMin=Vect[0].x;
	float xMax=Vect[0].x;
	float yMin=Vect[0].y;
	float yMax=Vect[0].y;
	for (int i=1; i < Vect.size(); i++) {
		if (Vect[i].x < xMin) xMin=Vect[i].x;
		if (Vect[i].x > xMax) xMax=Vect[i].x;
		if (Vect[i].y < yMin) yMin=Vect[i].y;
		if (Vect[i].y > yMax) yMax=Vect[i].y;
	}
	// informa sugli assi
	cout << "Determinazione dei fattori di scala per il Plot " << endl;
	cout << "asse X da " << xMin << " a " << xMax << endl; 
    cout << "asse Y da " << yMin << " a " << yMax << endl;
	// Scala le coppie x,y
	for (i=0; i < Vect.size(); i++) {
		Vect[i].x= xOffSet + (Vect[i].x-xMin) / (xMax-xMin) * WinDimX;
		Vect[i].y= yOffSet + WinDimY - (Vect[i].y-yMin) / (yMax-yMin) * WinDimY;
		cout << '[' << i << "] " << Vect[i].x <<" "<< Vect[i].y << endl;
	}
	// Traccia gli assi

	RaySegment asseX(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet,yOffSet),Black,0.1,true);
	RaySegment asseY(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet+WinDimX,yOffSet+WinDimY),Black,0.1,true);
	asseX.Draw();
	asseY.Draw();

}


// costruisce il grafico
void mostraDati(SimpleWindow &W, vector<Point> &Vect) {
	scala(W,Vect);
	const float Unit=0.25;
	for (int i=0; i < Vect.size(); i++) {
		RectangleShape R(W,Vect[i].x,Vect[i].y, Red, Unit, Unit);
		R.Draw();
	}
}


// finestra per il grafico
SimpleWindow W("Plot Dati",10,10);



int ApiMain() {
     vector<Point> Dati;

	 // lettuara dati
	 cout << "Vuoi leggere i dati da tastiera o da file? (t/f) " << flush;
	 char c;
	 cin >> c ;
	 if ((c=='t') || (c=='T')) leggiDatiDaTastiera(Dati);
	 else leggiDatiDaFile(Dati);
	 
	 // costruzione grafico
	 W.Open();
	 mostraDati(W,Dati); 
	 cout << " CTRL-C per teminare il programma!!!"  << endl;
	 return 0;
}