/* bianchi dario
nov 2002
risolve equazione di Laplace
(problema di trasmissione del calore in una lastra piana)
*/


#include <iostream>
#include <vector>
#include <string>

using namespace std;



const int dimAutomaR = 11;  //Dimensione automa
const int dimAutomaC = 11;  //Dimensione automa
const int maxNumeroCicli = 1000; //Numero cicli di aggiornamento
const double MaxError = 0.001;  //Errore per cella (Per fine run)  


// cella 
class Cella {
public:
	// costruttore
    Cella();
	//costruttore
	Cella(double temperatura, bool sulBordo);
	// facilitatori
	void stampaCella();
	// modificatori
	int applicaRegole(int r, int c);
	void aggiornaCella();
	
	
private:
	// stato attuale
	double temperatura;
	// stato nuovo
	double nuovaTemperatura;
	// sul bordo non si fa nulla
	bool sulBordo;
};

class Automa {

public:

// Costruttore 		
	Automa(int dimR,int dimC) ;
// ritorna un reference alla cella r,c 
	//(tiene conto delle dimensioni della Automa))
	Cella &Automa::getCella(int r,int c);	
	// visualizza l Automa come matrice di {' ',A,B}
	void visualizza() ;	
	// dopo aver calcolato il nuovo stato per tutte le celle 
	// si procede all' aggiornamento in modo sincrono della Automa
	void aggiornaCelle() ;
	// un  ciclo di aggiornamento e calcoli statistiche
	void cicloAggiornamento(int numCiclo);

private:
	vector < vector < Cella > > Griglia;
	int numRighe;
	int numColonne;
};


// calcola l' errore quadratico medio
class Error {
private:
	double sommaQuadrati;
	int numDati;
	double MaxErroreQuadratico;
public:
	Error();
	void reset();
	void accumula(double differenza);  
	double getMeanSqrErr();
	double getMaxSqrErr();
};