/* bianchi dario
nov 2002
risolve equazione di Laplace
(problema di trasmissione del calore in una lastra piana)
*/

#include <iostream>
#include<iomanip>
#include <vector>
#include <string>
#include <math.h>

#include "laplace.h"
using namespace std;



// variabili gloabali 

bool debug =false;
Automa g(dimAutomaR,dimAutomaC);
Error err;

// Cella

Cella::Cella(){
	sulBordo=false;
	temperatura=0;
	nuovaTemperatura=0;
	}

Cella::Cella(double temp, bool sulBor){
	temperatura=temp;
	nuovaTemperatura=0.0;
	sulBordo=sulBor;
}



// le celle ai bordi non cambiano
// le altre celle assumono un valore che e' la media delle 4 vicine
	
int Cella::applicaRegole(int r, int c) {
	if (!sulBordo) {
		nuovaTemperatura=
			(g.getCella(r+1,c).temperatura+
			 g.getCella(r,c+1).temperatura+
			 g.getCella(r-1,c).temperatura+
			 g.getCella(r,c-1).temperatura) / 4.0;
		 return 1;		
			 }
	else return 0;
}
	
	
void Cella::aggiornaCella() {
	if (!sulBordo) {
		// accumula errore
		err.accumula(nuovaTemperatura-temperatura);
		temperatura=nuovaTemperatura;
	}
}

void Cella::stampaCella() {
	if (temperatura!=0.0) // lo 0.0 usa un formato diverso per incolonnare
	cout << " " << setw(6) << setprecision(5) << showpoint << temperatura;
else 
	cout << " " << setw(6) << setprecision(3) << showpoint << temperatura;
}


// AUTOMA

Automa::Automa(int dimR,int dimC) {
		numRighe=dimR;
		numColonne=dimC;
		// dimensiona la griglia
	    Griglia.resize(numRighe,vector<Cella>(numColonne,Cella()));
		// inizializza le celle
/*

    100        200


    300        0
*/
		for (int riga=0; riga < numRighe; riga++) {
				Griglia[riga][0]=Cella(100+20*riga,true);
				//Griglia[riga][0].temperatura=100+20*riga;
				//Griglia[riga][0].sulBordo=true;
				Griglia[riga][numColonne-1]=Cella(200-20*riga,true);
				//Griglia[riga][numColonne-1].temperatura=200-20*riga;
				//Griglia[riga][numColonne-1].sulBordo=true;
		}
		for (int colonna=0; colonna < numColonne; colonna++) {
				//Griglia[0][colonna].temperatura=100+10*colonna;
				//Griglia[0][colonna].sulBordo=true;
				Griglia[0][colonna]=Cella(100+10*colonna,true);
				//Griglia[numRighe-1][colonna].temperatura=300-30*colonna;
				//Griglia[numRighe-1][colonna].sulBordo=true;
				Griglia[numRighe-1][colonna]=Cella(300-30*colonna,true);
		}
	}
	
// Restituisce un reference alla cella 
// Tiene conto delle dimensioni dell' automa
Cella &Automa::getCella(int r, int c){
	 r=(r+numRighe)%numRighe;
	 c=(c+numColonne)%numColonne;
	 return (Cella &) Griglia[r][c];
}


// AUTOMA 
	// visualizza la Automa 
void Automa::visualizza() {
		for (int riga=0; riga < numRighe; riga++) {
			for (int colonna=0; colonna < numColonne; colonna++) {
				Griglia[riga][colonna].stampaCella() ;
			}
			cout << endl;
		}
	cout << endl;
	}


	// dopo aver calcolato il nuovo stato per tutte le celle 
	// si procede all' aggiornamento in modo sincrono della Automa
void Automa::aggiornaCelle() {
		int riga,colonna,numRegola;
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				numRegola=Griglia[riga][colonna].applicaRegole(riga,colonna);
				if (debug){
					cout <<"posizione " << riga << colonna << "regola " ;
					cout <<	numRegola << endl;
				}
			}
		}
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				Griglia[riga][colonna].aggiornaCella() ;
			}
		}
	}




	// un sequenza di cicli di aggiornamento e relativa visualizzazione
void Automa::cicloAggiornamento(int numCiclo){
		aggiornaCelle();
		// cout << numCiclo << " " ;

	}
// ERROR
// Calcola Errore Quadratico Medio
Error::Error(){
	numDati=0;
	sommaQuadrati=0.0;
	MaxErroreQuadratico=0.0;
}
	
void Error::reset(){
	numDati=0;
	sommaQuadrati=0.0;
	MaxErroreQuadratico=0.0;
}

void Error::accumula(double differenza){
	double dd=differenza*differenza;
	sommaQuadrati=sommaQuadrati+dd;
	numDati++;
	if (dd > MaxErroreQuadratico) {
		MaxErroreQuadratico = dd;
	}
}
	
double Error::getMeanSqrErr() {
	if (numDati>0) return sommaQuadrati/(double) numDati;
	else return 0.0;
}

double Error::getMaxSqrErr() {
	 return MaxErroreQuadratico;
}


void main(){
	
	cout << "Stato Iniziale " << endl;	
	g.visualizza();
	int numCiclo=0;
	do {
	err.reset();
	g.cicloAggiornamento(numCiclo);
	numCiclo++; }
	while ((err.getMaxSqrErr() > MaxError*MaxError) 
		&& (numCiclo < maxNumeroCicli));

	cout << "Cicli eseguiti: " << numCiclo << endl;
	cout << "Errore quadratico medio per cella: " << err.getMeanSqrErr() <<endl;
		cout << "Errore quadratico massimo: " << err.getMaxSqrErr() <<endl;
	
	cout << "Stato Finale " << endl;
	g.visualizza();
	cout << "Premi un tasto per finire " << flush ;
	cin.get();
}


