/*

Dario Bianchi Nov. 2002

Soluzione di un sistema di equazioni lineari con la
eliminazione di Gauss-Jordan

i=1
j=1
while (i <= m and j<= n) do
  # Find pivot in column j, starting in row i:
  max_val = abs(A[i,j])
  max_ind = i
  for k=i+1 to m do
    if abs(A[k,j]) > max_val then
      max_val = abs(A[k,j])
      max_ind = k
    end_if
  end_for
  if max_val <> 0 then
    switch rows i and max_ind
    divide row i by max_val
    for u > i+1 to m do
      add - A[u,j] * row i to row u
    end_for
    i = i + 1
  end_if
  j = j + 1
end_while

*/


#include <iostream>
#include <fstream>
#include <vector>
#include <math.h>

using namespace std;

// valore di confronto per decidere se un elemento e' <> da 0
const double epsilon = 0.000001; 
const bool debug = true;

typedef  vector <vector<double> > Matrice;


// Aspetta un tasto (per non far chiudere la finestra DOS)
void aspettaTasto() {
	cout << "Per finire premi un tasto." << endl;
	cin.get();
}

// Moltiplica due matrici righe per colonne e ritorna un matrice
Matrice  matMult( Matrice & A, Matrice & B) {
	int nRigheA,nColA,nRigheB,nColB;
	nRigheA=A.size();
	nColA=A[0].size();
    nRigheB=A.size();
	nColB=B[0].size();
	Matrice C;
	if (nColA != nRigheB) {
		cout << " le matrici non sono compatibili " << endl;
		aspettaTasto();
		return C;
	}
	C.resize (nRigheA, vector<double>(nColB,0.0));
	for (int i=0 ; i <nRigheA; i++) {
		for (int j=0; j< nColB; j++) {
			for (int k=0; k<nColA; k++) {
				C[i][j]=C[i][j]+A[i][k]*B[k][j];
			}
		}
	}
	return C;
}





// legge dallo stream fin una matrice  
// passa indietro numero righe e colonne
leggiDati(ifstream &fin, Matrice &A, int &numR, int &numC) {
		fin >> numR >> numC;
		A.resize (numR, vector<double>(numC,0.0));
		for (int i=0; i< numR ; i++) {
			for (int j=0; j< numC; j++) {
				fin >> A[i][j];
			}
		}
}

// visualizza una matrice di numR numC righe e colonne
void visualizza(Matrice &A, int numR, int numC) {
	for (int i=0; i< numR; i++) {
			for (int j=0; j<numC; j++) {
				cout << A[i][j] << " ";
			}
			cout << endl;
		}
	cout << endl;
}


// trova il miglior pivot per la posizione i,i 
// guardando tutte le righe successive in colonna i 
bool trovaPivot(Matrice &A, int i, int & maxind,int numR) {
	int j= i;
	double maxval = fabs(A[i][j]);
	maxind = i;
	for (int k = i+1; k < numR; k++) {
		if (maxval < fabs(A[k][j])) {
				maxval = fabs(A[k][j]);
				maxind = k;
		}
	}
	if (maxval > epsilon) return true;
	else return false;
}

// scambia la riga i con la riga j	
void scambiaRighe(Matrice &A, int i, int j, int numC, double &det) {
	double temp;
	if (i != j) {
		det=-det;
        for (int k=0; k<numC; k++) {
			temp = A[i][k];
			A[i][k]=A[j][k];
			A[j][k]=temp;
		}
	}
}


// normalizza, cioe' divide la riga i per A(i,i)
void normalizza(Matrice &A, int i, int numC, double &det) {
	det=det * A[i][i];
        for (int k= i+1; k < numC; k++) {
			A[i][k]=A[i][k]/A[i][i];
		}
		A[i][i]=1.0;
	}


bool gauss_jordan(Matrice &A, int numR,int numC, double &det) {
	det=1.0;
	for (int i=0;  i < numR; i++){
			int maxind ; // riga su cui fare il pivot
			// trova il pivot in colonna j partendo dalla riga i
			if (!trovaPivot(A, i, maxind, numR)) {
				cout << " non e' possibile risolvere il sistema " << endl;
				aspettaTasto();
				return false;
			}
			else {
				
				// scambia riga i e maxind
				scambiaRighe(A, i,maxind,numC, det);
				if (debug) {
					cout << "scambio righe" << endl;
					visualizza(A, numR, numC);
				}
				// divide la riga i per il valore di pivot
				normalizza(A, i,numC, det);
				if (debug) {
					cout << "normalizza" << endl;
					visualizza(A, numR, numC);
				}
				for (int u = 0; u < numR; u++) {
						if (u!=i) {
							for (int k=i+1 ; k< numC; k++){
									A[u][k] = A[u][k] -A[u][i]  * A[i][k];
							}
							A[u][i]=0.0;
						}
				}
				if (debug) {
					cout << "pivot: i,i " << i << " " << i << endl;
					visualizza(A, numR, numC);
				}
			}
	}
return true;
}
	
Matrice  invertiMatrice(Matrice &Mat) {
	// aggiunge a destra una matrice unitaria
	double determinante;
	int numR= Mat.size();
	Matrice A;
	A.resize (numR, vector<double>(numR*2,0.0));
	Matrice Inv;
	Inv.resize (numR, vector<double>(numR*2,0.0));
	//matrice da invertire
	for (int i=0 ; i< numR; i++) {
		for (int j=0; j<numR ; j++ ) {
			A[i][j]=Mat[i][j];
		} 
	// matrice unitaria (messa a destra)
	for (j=numR; j < numR*2; j++) {
			if (j == i + numR) {
				A[i][j]=1;
			}
			else {
				A[i][j]=0;
			}
		}
	} 
	cout << "mastrice estesa per l' inversione" << endl;
	visualizza(A,numR,numR*2);
	// chiama gauss_jordan per l' inversione
	if (gauss_jordan(A,numR,numR*2,determinante)) { 
			cout <<endl << " risultato : " << endl;
			visualizza(A, numR, numR*2);		
			cout << "determinante = " << determinante << endl;
		}
	// estrae la matrice inversa (meta' a destra) 
	for (i=0 ; i< numR; i++) {
		for (int j=0; j < numR; j++) {
			Inv[i][j]=A[i][j+numR];
		}
	} 
return Inv;
}




void main(){
    Matrice Sistema;
    int numRighe, numColonne;
	double determinante;

// Apre il file su cui sono sceritte le varie matrici
	ifstream fin("esempi.txt");
	if (!fin) {
		cout << " impossibile aprire il file " << endl;
		aspettaTasto();
		exit(0);
	}

// Test risoluzione sistema lineare e calcolo determinante
	leggiDati(fin, Sistema, numRighe, numColonne);
	cout << "sistema originale" << endl;
	visualizza(Sistema, numRighe, numColonne);
	if (gauss_jordan(Sistema,numRighe,numColonne,determinante)) { 
		cout <<endl << " risultato : " << endl;
		visualizza(Sistema, numRighe, numColonne);		
		cout << "determinante = " << determinante << endl;
	}

// Test inversdione matrice
	Matrice Mat;
	Matrice MatInversa;
	Matrice MatProdotto;
	    leggiDati(fin, Mat, numRighe, numColonne);
		cout << "matrice da invertire" << endl;
		visualizza(Mat, numRighe, numColonne);
		MatInversa= invertiMatrice(Mat);
		cout << "matrice inversa" << endl;
		visualizza(MatInversa, numRighe, numColonne);
        MatProdotto= matMult(Mat,MatInversa);
		cout << "prodotto matrice * matrice inversa " << endl;
		visualizza(MatProdotto, numRighe, numColonne);

// Un sistema in cui una riga e' ripetuta
leggiDati(fin, Sistema, numRighe, numColonne);

	cout << "sistema originale" << endl;
		visualizza(Sistema, numRighe, numColonne);
		if (gauss_jordan(Sistema,numRighe,numColonne,determinante)) { 
			cout <<endl << " risultato : " << endl;
			visualizza(Sistema, numRighe, numColonne);		
			cout << "determinante = " << determinante << endl;
		}
aspettaTasto();
		
}

